/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.NativeImageLoader;
import org.eclipse.swt.internal.image.FileFormat;

class URLImageDescriptor
extends ImageDescriptor
implements IAdaptable {
    private static long cumulativeTime;
    private static final String FILE_PROTOCOL = "file";
    private final String url;
    private static final Pattern XPATH_PATTERN;

    static {
        XPATH_PATTERN = Pattern.compile("(\\d+)x(\\d+)");
    }

    private ImageFileNameProvider createURLImageFileNameProvider() {
        return zoom -> {
            URL tempURL = URLImageDescriptor.getURL(this.url);
            if (tempURL != null) {
                boolean logIOException;
                boolean bl = logIOException = zoom == 100;
                if (zoom == 100) {
                    return URLImageDescriptor.getFilePath(tempURL, logIOException);
                }
                return URLImageDescriptor.getZoomedImageSource(tempURL, this.url, zoom, u -> URLImageDescriptor.getFilePath(u, logIOException));
            }
            return null;
        };
    }

    private ImageDataProvider createURLImageDataProvider() {
        return zoom -> this.getImageData(zoom);
    }

    URLImageDescriptor(URL url) {
        super(true);
        this.url = url.toExternalForm();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void other;
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        URLImageDescriptor uRLImageDescriptor = (URLImageDescriptor)o;
        return other.url.equals(this.url);
    }

    @Override
    public ImageData getImageData(int zoom) {
        URL tempURL = URLImageDescriptor.getURL(this.url);
        if (tempURL != null) {
            if (zoom == 100 || URLImageDescriptor.canLoadAtZoom(tempURL, zoom)) {
                return URLImageDescriptor.getImageData(tempURL, 100, zoom);
            }
            return URLImageDescriptor.getZoomedImageSource(tempURL, this.url, zoom, u -> URLImageDescriptor.getImageData(u, zoom, zoom));
        }
        return null;
    }

    private static <R> R getZoomedImageSource(URL url, String urlString, int zoom, Function<URL, R> getImage) {
        URL xPathUrl;
        R xdata;
        URL xUrl = URLImageDescriptor.getxURL(url, zoom);
        if (xUrl != null && (xdata = getImage.apply(xUrl)) != null) {
            return xdata;
        }
        String xpath = URLImageDescriptor.getxPath(urlString, zoom);
        if (xpath != null && (xPathUrl = URLImageDescriptor.getURL(xpath)) != null) {
            return getImage.apply(xPathUrl);
        }
        return null;
    }

    private static ImageData getImageData(URL url, int fileZoom, int targetZoom) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream in = URLImageDescriptor.getStream(url);){
                if (in != null) {
                    return URLImageDescriptor.loadImageFromStream(new BufferedInputStream(in), fileZoom, targetZoom);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SWTException e) {
            if (e.code != 40) {
                throw e;
            }
        }
        catch (IOException e) {
            Policy.logException(e);
        }
        return null;
    }

    private static ImageData loadImageFromStream(InputStream stream, int fileZoom, int targetZoom) {
        return (ImageData)((DPIUtil.ElementAtZoom)NativeImageLoader.load((DPIUtil.ElementAtZoom)new DPIUtil.ElementAtZoom((Object)stream, fileZoom), (ImageLoader)new ImageLoader(), (int)targetZoom).get(0)).element();
    }

    private static boolean canLoadAtZoom(URL url, int zoom) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = URLImageDescriptor.getStream(url);){
                if (in != null) {
                    return FileFormat.canLoadAtZoom((DPIUtil.ElementAtZoom)new DPIUtil.ElementAtZoom((Object)in, 100), (int)zoom);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Policy.logException(e);
        }
        return false;
    }

    private static InputStream getStream(URL url) {
        try {
            if (InternalPolicy.OSGI_AVAILABLE) {
                url = URLImageDescriptor.resolvePathVariables(url);
            }
            return url.openStream();
        }
        catch (IOException e) {
            String path;
            if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && ((path = url.getPath()).endsWith("@2x.png") || path.endsWith("@1.5x.png"))) {
                Policy.getLog().log((IStatus)Status.warning((String)("High-resolution image missing: " + String.valueOf(url)), (Throwable)e));
            }
            return null;
        }
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }

    private static URL getxURL(URL url, int zoom) {
        String path = url.getPath();
        int dot = path.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x_PNG_FOR_GIF && ".gif".equalsIgnoreCase(tail)) {
                tail = ".png";
            }
            String x = zoom == 150 ? "@1.5x" : "@2x";
            try {
                String file = lead + x + tail;
                if (url.getQuery() != null) {
                    file = file + "?" + url.getQuery();
                }
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e) {
                Policy.logException(e);
            }
        }
        return null;
    }

    private static String getxPath(String name, int zoom) {
        Matcher matcher = XPATH_PATTERN.matcher(name);
        if (matcher.find()) {
            try {
                int currentWidth = Integer.parseInt(matcher.group(1));
                int desiredWidth = Math.round((float)zoom / 100.0f * (float)currentWidth);
                int currentHeight = Integer.parseInt(matcher.group(2));
                int desiredHeight = Math.round((float)zoom / 100.0f * (float)currentHeight);
                String lead = name.substring(0, matcher.start(1));
                String tail = name.substring(matcher.end(2));
                return lead + desiredWidth + "x" + desiredHeight + tail;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getFilePath(URL url, boolean logException) {
        try {
            if (!InternalPolicy.OSGI_AVAILABLE) {
                return URLImageDescriptor.getFilePath(url);
            }
            url = URLImageDescriptor.resolvePathVariables(url);
            URL locatedURL = FileLocator.toFileURL((URL)url);
            return URLImageDescriptor.getFilePath(locatedURL);
        }
        catch (IOException e) {
            String path;
            if (logException) {
                Policy.logException(e);
            } else if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && ((path = url.getPath()).endsWith("@2x.png") || path.endsWith("@1.5x.png"))) {
                Policy.getLog().log((IStatus)Status.warning((String)("High-resolution image missing: " + String.valueOf(url)), (Throwable)e));
            }
            return null;
        }
    }

    private static String getFilePath(URL url) {
        File file;
        if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol()) && (file = IPath.fromOSString((String)url.getPath()).toFile()).exists()) {
            return file.getPath();
        }
        return null;
    }

    private static URL resolvePathVariables(URL url) {
        URL platformURL = FileLocator.find((URL)url);
        if (platformURL != null) {
            url = platformURL;
        }
        return url;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static URL getURL(String urlString) {
        URL result = null;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Policy.logException(e);
        }
        return result;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == URL.class) {
            return adapter.cast(URLImageDescriptor.getURL(this.url));
        }
        if (adapter == ImageFileNameProvider.class) {
            return adapter.cast(this.createURLImageFileNameProvider());
        }
        if (adapter == ImageDataProvider.class) {
            return adapter.cast(this.createURLImageDataProvider());
        }
        return null;
    }
}

