/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTChooserEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class PTFontEditor
extends PTChooserEditor {
    @Override
    protected void openWindow(PTWidget widget, Item item, PTProperty property) {
        FontDialog dialog = new FontDialog(widget.getWidget().getShell());
        FontData result = dialog.open();
        if (result != null && result.getName() != null && !"".equals(result.getName().trim())) {
            property.setValue(result);
            if (item instanceof TableItem) {
                ((TableItem)item).setText(1, this.getTextFor(property));
            } else {
                ((TreeItem)item).setText(1, this.getTextFor(property));
            }
        }
    }

    @Override
    protected String getTextFor(PTProperty property) {
        if (property.getValue() == null) {
            return "";
        }
        FontData fontData = (FontData)property.getValue();
        StringBuilder sb = new StringBuilder();
        if (fontData != null) {
            sb.append(fontData.getName()).append(",").append(fontData.getHeight()).append(" pt");
            if ((fontData.getStyle() & 1) == 1) {
                sb.append(", ").append(ResourceManager.getLabel((String)"bold"));
            }
            if ((fontData.getStyle() & 2) == 2) {
                sb.append(", ").append(ResourceManager.getLabel((String)"italic"));
            }
        }
        return sb.toString();
    }

    @Override
    protected Color getBackgroundColor(PTProperty property) {
        return null;
    }
}

