/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class AutoScrollDragMode
implements IDragMode {
    private final boolean horizontal;
    private final boolean vertical;
    private AutoScrollRunnable runnable;
    protected int horizontalBorderOffset = GUIHelper.convertHorizontalPixelToDpi(25);
    protected int verticalBorderOffset = GUIHelper.convertVerticalPixelToDpi(25);

    public AutoScrollDragMode(boolean horizontal, boolean vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        Rectangle clientArea = natTable.getClientAreaProvider().getClientArea();
        int x = event.x;
        int y = event.y;
        int horizontalDiff = 0;
        SelectionLayer.MoveDirectionEnum horizontal = SelectionLayer.MoveDirectionEnum.NONE;
        if (this.horizontal) {
            if (event.x < this.horizontalBorderOffset) {
                horizontal = SelectionLayer.MoveDirectionEnum.LEFT;
                x = Math.max(0, event.x);
                horizontalDiff = -event.x;
            } else if (event.x > clientArea.width - this.horizontalBorderOffset) {
                horizontal = SelectionLayer.MoveDirectionEnum.RIGHT;
                int column = natTable.getColumnPositionByX(x);
                int columnWidth = natTable.getColumnWidthByPosition(column);
                x = clientArea.width - columnWidth / 2;
                horizontalDiff = event.x - clientArea.width;
            }
        }
        int verticalDiff = 0;
        SelectionLayer.MoveDirectionEnum vertical = SelectionLayer.MoveDirectionEnum.NONE;
        if (this.vertical) {
            if (event.y < this.verticalBorderOffset) {
                vertical = SelectionLayer.MoveDirectionEnum.UP;
                y = 0;
                verticalDiff = -event.y;
            } else if (event.y > clientArea.height - this.verticalBorderOffset) {
                vertical = SelectionLayer.MoveDirectionEnum.DOWN;
                int row = natTable.getRowPositionByY(y);
                int rowHeight = natTable.getRowHeightByPosition(row);
                y = clientArea.height - rowHeight / 2;
                verticalDiff = event.y - clientArea.height;
            }
        }
        if (!(SelectionLayer.MoveDirectionEnum.NONE.equals((Object)horizontal) && SelectionLayer.MoveDirectionEnum.NONE.equals((Object)vertical) || this.runnable != null)) {
            this.runnable = new AutoScrollRunnable(natTable, x, y, horizontal, vertical);
            this.runnable.schedule();
        } else if (SelectionLayer.MoveDirectionEnum.NONE.equals((Object)horizontal) && SelectionLayer.MoveDirectionEnum.NONE.equals((Object)vertical) && this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        } else if (this.runnable != null) {
            this.runnable.calculateRepeatDelay(horizontalDiff, verticalDiff);
        }
        this.performDragAction(natTable, x, y, horizontal, vertical);
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
    }

    protected void performDragAction(NatTable natTable, int x, int y, SelectionLayer.MoveDirectionEnum horizontal, SelectionLayer.MoveDirectionEnum vertical) {
    }

    protected class AutoScrollRunnable
    implements Runnable {
        private final NatTable natTable;
        private final Display display;
        private final SelectionLayer.MoveDirectionEnum horizontal;
        private final SelectionLayer.MoveDirectionEnum vertical;
        private final int x;
        private final int y;
        private int repeatDelay = 500;
        private boolean active = true;

        public AutoScrollRunnable(NatTable natTable, int x, int y, SelectionLayer.MoveDirectionEnum horizontal, SelectionLayer.MoveDirectionEnum vertical) {
            this.natTable = natTable;
            this.display = natTable.getDisplay();
            this.horizontal = horizontal;
            this.vertical = vertical;
            this.x = x;
            this.y = y;
        }

        public void schedule() {
            if (this.display != null) {
                this.display.timerExec(500, (Runnable)this);
            }
        }

        public void calculateRepeatDelay(int horizontalDiff, int verticalDiff) {
            int factor;
            if (!SelectionLayer.MoveDirectionEnum.NONE.equals((Object)this.horizontal)) {
                factor = horizontalDiff / 5;
                factor = Math.min(factor, 10);
                this.repeatDelay = 500 - factor * 49;
            }
            if (!SelectionLayer.MoveDirectionEnum.NONE.equals((Object)this.vertical)) {
                factor = verticalDiff / 5;
                factor = Math.min(factor, 10);
                this.repeatDelay = 500 - factor * 49;
            }
        }

        public void cancel() {
            this.active = false;
        }

        @Override
        public void run() {
            if (this.active) {
                if (!(SelectionLayer.MoveDirectionEnum.NONE.equals((Object)this.horizontal) && SelectionLayer.MoveDirectionEnum.NONE.equals((Object)this.vertical) || !this.natTable.doCommand(new ViewportDragCommand(this.horizontal, this.vertical)))) {
                    AutoScrollDragMode.this.performDragAction(this.natTable, this.x, this.y, this.horizontal, this.vertical);
                }
                this.display.timerExec(this.repeatDelay, (Runnable)this);
            }
        }
    }
}

