/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.command.AbstractMultiRowCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class MultiRowResizeCommand
extends AbstractMultiRowCommand {
    private int commonRowHeight = -1;
    protected Map<RowPositionCoordinate, Integer> rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();
    private final boolean downScale;

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int commonRowHeight) {
        this(layer, rowPositions, commonRowHeight, false);
    }

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int commonRowHeight, boolean downScale) {
        super(layer, rowPositions);
        this.commonRowHeight = commonRowHeight;
        this.downScale = downScale;
    }

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int[] rowHeights) {
        this(layer, rowPositions, rowHeights, false);
    }

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int[] rowHeights, boolean downScale) {
        super(layer, rowPositions);
        int i = 0;
        while (i < rowPositions.length) {
            this.rowPositionToHeight.put(new RowPositionCoordinate(layer, rowPositions[i]), rowHeights[i]);
            ++i;
        }
        this.downScale = downScale;
    }

    protected MultiRowResizeCommand(MultiRowResizeCommand command) {
        super(command);
        this.commonRowHeight = command.commonRowHeight;
        this.rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>(command.rowPositionToHeight);
        this.downScale = command.downScale;
    }

    public int getCommonRowHeight() {
        return this.commonRowHeight;
    }

    public int getRowHeight(int rowPosition) {
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
            if (rowPositionCoordinate.getRowPosition() != rowPosition) continue;
            return this.rowPositionToHeight.get(rowPositionCoordinate);
        }
        return this.commonRowHeight;
    }

    public boolean downScaleValue() {
        return this.downScale;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashMap<RowPositionCoordinate, Integer> newRowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
            RowPositionCoordinate convertedRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(rowPositionCoordinate, targetLayer);
            if (convertedRowPositionCoordinate == null) continue;
            newRowPositionToHeight.put(convertedRowPositionCoordinate, this.rowPositionToHeight.get(rowPositionCoordinate));
        }
        if (super.convertToTargetLayer(targetLayer)) {
            this.rowPositionToHeight = newRowPositionToHeight;
            return true;
        }
        return false;
    }

    @Override
    public MultiRowResizeCommand cloneCommand() {
        return new MultiRowResizeCommand(this);
    }
}

