/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.AbstractMultiColumnCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.swt.graphics.Drawable;

public class AutoResizeColumnsCommand
extends AbstractMultiColumnCommand {
    private final IConfigRegistry configRegistry;
    private final GCFactory gcFactory;
    private final boolean transformPositions;

    public AutoResizeColumnsCommand(InitializeAutoResizeColumnsCommand initCommand) {
        super(initCommand.getSourceLayer(), initCommand.getColumnPositions());
        this.configRegistry = initCommand.getConfigRegistry();
        this.gcFactory = initCommand.getGCFactory();
        this.transformPositions = true;
    }

    public AutoResizeColumnsCommand(NatTable natTable, int ... columnPositions) {
        this(natTable, false, columnPositions);
    }

    public AutoResizeColumnsCommand(NatTable natTable, boolean transformPositions, int ... columnPositions) {
        super(natTable, columnPositions);
        this.configRegistry = natTable.getConfigRegistry();
        this.gcFactory = new GCFactory((Drawable)natTable);
        this.transformPositions = transformPositions;
    }

    protected AutoResizeColumnsCommand(AutoResizeColumnsCommand command) {
        super(command);
        this.configRegistry = command.configRegistry;
        this.gcFactory = command.gcFactory;
        this.transformPositions = command.transformPositions;
    }

    @Override
    public ILayerCommand cloneCommand() {
        return new AutoResizeColumnsCommand(this);
    }

    public GCFactory getGCFactory() {
        return this.gcFactory;
    }

    public IConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }

    public boolean doPositionTransformation() {
        return this.transformPositions;
    }
}

