/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.group.command.ViewportSelectColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRegionCommand;

public class ViewportSelectColumnGroupCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectColumnGroupCommand> {
    private final AbstractLayer viewportLayer;

    public ViewportSelectColumnGroupCommandHandler(AbstractLayer viewportLayer) {
        if (viewportLayer == null) {
            throw new IllegalArgumentException("viewportLayer cannot be null!");
        }
        this.viewportLayer = viewportLayer;
    }

    @Override
    protected boolean doCommand(ViewportSelectColumnGroupCommand command) {
        ILayer underlyingLayer = this.viewportLayer.getUnderlyingLayerByPosition(0, 0);
        ColumnPositionCoordinate underlyingStart = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(command.getLayer(), command.getOriginColumnPosition()), underlyingLayer);
        int span = command.getColumnSpan();
        if (underlyingStart == null) {
            span += command.getOriginColumnPosition();
            underlyingStart = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(command.getLayer(), 0), underlyingLayer);
        }
        if (underlyingStart != null) {
            SelectRegionCommand regionCommand = new SelectRegionCommand(underlyingLayer, underlyingStart.getColumnPosition(), 0, span, Integer.MAX_VALUE, command.isWithShiftMask(), command.isWithControlMask());
            RowPositionCoordinate underlyingRow = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(this.viewportLayer, 0), underlyingLayer);
            regionCommand.setAnchorRowPosition(underlyingRow.rowPosition);
            if (command.getOriginColumnPosition() <= 0) {
                ColumnPositionCoordinate underlyingColumn = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(this.viewportLayer, 0), underlyingLayer);
                regionCommand.setAnchorColumnPosition(underlyingColumn.columnPosition);
            }
            underlyingLayer.doCommand(regionCommand);
        }
        return true;
    }

    @Override
    public Class<ViewportSelectColumnGroupCommand> getCommandClass() {
        return ViewportSelectColumnGroupCommand.class;
    }
}

