/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.gui;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.DialogEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.CellEditDialog;
import org.eclipse.nebula.widgets.nattable.edit.gui.ICellEditDialog;
import org.eclipse.nebula.widgets.nattable.edit.gui.TickUpdateCellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tickupdate.ITickUpdateHandler;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class CellEditDialogFactory {
    private CellEditDialogFactory() {
    }

    public static ICellEditDialog createCellEditDialog(Shell parentShell, Object originalCanonicalValue, ILayerCell cell, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        ICellEditDialog result = null;
        if (cellEditor instanceof ICellEditDialog) {
            cellEditor.activateCell((Composite)parentShell, originalCanonicalValue, EditModeEnum.DIALOG, new DialogEditHandler(), cell, configRegistry);
            result = (ICellEditDialog)((Object)cellEditor);
        } else {
            ITickUpdateHandler tickUpdateHandler = configRegistry.getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, DisplayMode.EDIT, (List<String>)cell.getConfigLabels());
            result = tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(cell.getDataValue()) ? new TickUpdateCellEditDialog(parentShell, originalCanonicalValue, cell, cellEditor, configRegistry, tickUpdateHandler) : new CellEditDialog(parentShell, originalCanonicalValue, cell, cellEditor, configRegistry);
        }
        result.setDialogSettings(configRegistry.getConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, DisplayMode.EDIT, (List<String>)cell.getConfigLabels()));
        return result;
    }
}

