/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class RowSpanningCopyDataCommandHandler
extends CopyDataCommandHandler {
    protected InternalCellClipboard clipboard;

    public RowSpanningCopyDataCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        super(selectionLayer);
        this.clipboard = clipboard;
    }

    public RowSpanningCopyDataCommandHandler(SelectionLayer selectionLayer, ILayer columnHeaderLayer, InternalCellClipboard clipboard) {
        super(selectionLayer, columnHeaderLayer, null);
        this.clipboard = clipboard;
    }

    @Override
    protected void internalDoCommand(CopyDataToClipboardCommand command, ILayerCell[][] assembledCopiedDataStructure) {
        super.internalDoCommand(command, assembledCopiedDataStructure);
        this.preInternalCopy();
        if (this.clipboard != null) {
            this.clipboard.setCopiedCells(assembledCopiedDataStructure);
        }
        this.postInternalCopy();
    }

    @Override
    protected ILayerCell[] assembleBody(int currentRowPosition) {
        int[] selectedColumns = this.getSelectedColumnPositions();
        ILayerCell[] bodyCells = new ILayerCell[selectedColumns.length];
        int columnPosition = 0;
        while (columnPosition < selectedColumns.length) {
            int selectedColumnPosition = selectedColumns[columnPosition];
            if (this.selectionLayer.isCellPositionSelected(selectedColumnPosition, currentRowPosition)) {
                ILayerCell cell = null;
                if (this.getCopyLayer() == null) {
                    cell = this.selectionLayer.getCellByPosition(selectedColumnPosition, currentRowPosition);
                } else {
                    int copyColPos = LayerUtil.convertColumnPosition(this.selectionLayer, selectedColumnPosition, this.getCopyLayer());
                    int copyRowPos = LayerUtil.convertRowPosition(this.selectionLayer, currentRowPosition, this.getCopyLayer());
                    cell = this.getCopyLayer().getCellByPosition(copyColPos, copyRowPos);
                }
                if (cell != null && cell.getOriginRowPosition() == cell.getRowPosition() && this.isCopyAllowed(cell)) {
                    bodyCells[columnPosition] = cell;
                }
            }
            ++columnPosition;
        }
        if (!this.isEmpty(bodyCells)) {
            return bodyCells;
        }
        return null;
    }

    protected void preInternalCopy() {
    }

    protected void postInternalCopy() {
        this.selectionLayer.fireLayerEvent(new VisualRefreshEvent(this.selectionLayer));
    }
}

