/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.e4.painterfactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.extension.e4.painterfactory.CellPainterCreator;
import org.eclipse.nebula.widgets.nattable.extension.e4.painterfactory.CellPainterWrapperCreator;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupExpandCollapseImagePainter;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.group.painter.RowGroupExpandCollapseImagePainter;
import org.eclipse.nebula.widgets.nattable.group.painter.RowGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.GradientBackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PasswordTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PercentageBarCellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TableCellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.VerticalTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CustomLineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortIconPainter;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class CellPainterFactory {
    public static final String BACKGROUND_PAINTER_KEY = "background";
    public static final String BACKGROUND_IMAGE_PAINTER_KEY = "image-background";
    public static final String GRADIENT_BACKGROUND_PAINTER_KEY = "gradient-background";
    public static final String DECORATOR_KEY = "decorator";
    public static final String LINE_BORDER_DECORATOR_KEY = "line-border";
    public static final String CUSTOM_LINE_BORDER_DECORATOR_KEY = "custom-line-border";
    public static final String BEVELED_BORDER_DECORATOR_KEY = "beveled-border";
    public static final String PADDING_DECORATOR_KEY = "padding";
    public static final String SORTABLE_HEADER_KEY = "sort-header";
    public static final String COLUMN_GROUP_HEADER_KEY = "column-group";
    public static final String ROW_GROUP_HEADER_KEY = "row-group";
    public static final String TREE_STRUCTURE_KEY = "tree";
    public static final String CHECKBOX_PAINTER_KEY = "checkbox";
    public static final String COMBOBOX_PAINTER_KEY = "combobox";
    public static final String IMAGE_PAINTER_KEY = "image";
    public static final String PASSWORD_PAINTER_KEY = "password";
    public static final String PERCENTAGEBAR_PAINTER_KEY = "percentage";
    public static final String TABLE_PAINTER_KEY = "table";
    public static final String TEXT_PAINTER_KEY = "text";
    public static final String NONE = "none";
    private final Map<String, CellPainterWrapperCreator> backgroundPainter = new HashMap<String, CellPainterWrapperCreator>();
    private final Map<String, CellPainterWrapperCreator> decoratorPainter = new HashMap<String, CellPainterWrapperCreator>();
    private final Map<String, CellPainterCreator> contentPainter = new HashMap<String, CellPainterCreator>();
    private static CellPainterFactory instance;

    public static CellPainterFactory getInstance() {
        if (instance == null) {
            instance = new CellPainterFactory();
        }
        return instance;
    }

    private CellPainterFactory() {
        this.backgroundPainter.put(BACKGROUND_PAINTER_KEY, (painterProperties, underlying) -> new BackgroundPainter(underlying));
        this.backgroundPainter.put(BACKGROUND_IMAGE_PAINTER_KEY, (painterProperties, underlying) -> {
            Image image = (Image)painterProperties.get("cell-background-image");
            return new BackgroundImagePainter(underlying, image);
        });
        this.backgroundPainter.put(GRADIENT_BACKGROUND_PAINTER_KEY, (painterProperties, underlying) -> {
            Boolean vertical = (Boolean)painterProperties.get("gradient-background-vertical");
            if (vertical == null) {
                vertical = false;
            }
            return new GradientBackgroundPainter(underlying, vertical.booleanValue());
        });
        this.decoratorPainter.put(LINE_BORDER_DECORATOR_KEY, (painterProperties, underlying) -> new LineBorderDecorator(underlying));
        this.decoratorPainter.put(CUSTOM_LINE_BORDER_DECORATOR_KEY, (painterProperties, underlying) -> new CustomLineBorderDecorator(underlying));
        this.decoratorPainter.put(BEVELED_BORDER_DECORATOR_KEY, (painterProperties, underlying) -> new BeveledBorderDecorator(underlying));
        this.decoratorPainter.put(PADDING_DECORATOR_KEY, (painterProperties, underlying) -> {
            Integer rightPadding;
            Integer leftPadding;
            Integer bottomPadding;
            Integer topPadding = (Integer)painterProperties.get("padding-top");
            if (topPadding == null) {
                topPadding = 0;
            }
            if ((bottomPadding = (Integer)painterProperties.get("padding-bottom")) == null) {
                bottomPadding = 0;
            }
            if ((leftPadding = (Integer)painterProperties.get("padding-left")) == null) {
                leftPadding = 0;
            }
            if ((rightPadding = (Integer)painterProperties.get("padding-right")) == null) {
                rightPadding = 0;
            }
            return new PaddingDecorator(underlying, topPadding.intValue(), rightPadding.intValue(), bottomPadding.intValue(), leftPadding.intValue(), false);
        });
        this.decoratorPainter.put(SORTABLE_HEADER_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            return new SortableHeaderTextPainter(underlying, CellEdgeEnum.RIGHT, (ICellPainter)new SortIconPainter(false, invert), false, 0, false);
        });
        this.decoratorPainter.put(COLUMN_GROUP_HEADER_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            return new ColumnGroupHeaderTextPainter(underlying, CellEdgeEnum.RIGHT, (ICellPainter)new ColumnGroupExpandCollapseImagePainter(false, invert), false, 0, false);
        });
        this.decoratorPainter.put(ROW_GROUP_HEADER_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            return new RowGroupHeaderTextPainter(underlying, CellEdgeEnum.BOTTOM, (ICellPainter)new RowGroupExpandCollapseImagePainter(false, invert), false, 0, true);
        });
        this.decoratorPainter.put(TREE_STRUCTURE_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            String postFix = "";
            if (invert) {
                postFix = "_inv";
            }
            TreeImagePainter imagePainter = new TreeImagePainter(false, GUIHelper.getImage((String)("right" + postFix)), GUIHelper.getImage((String)("right_down" + postFix)), null);
            return new IndentedTreeImagePainter(10, null, CellEdgeEnum.LEFT, (ICellPainter)imagePainter, false, 2, true);
        });
        this.contentPainter.put(TEXT_PAINTER_KEY, (painterProperties, underlying) -> {
            Object result = null;
            String textDirection = (String)painterProperties.get("text-direction");
            result = !"vertical".equalsIgnoreCase(textDirection) ? new TextPainter(false, false) : new VerticalTextPainter(false, false);
            this.initTextPainter((AbstractTextPainter)result, painterProperties);
            return result;
        });
        this.contentPainter.put(IMAGE_PAINTER_KEY, (painterProperties, underlying) -> {
            ImagePainter result = new ImagePainter(false);
            if (painterProperties.containsKey("calculate-cell-height")) {
                result.setCalculateByHeight(((Boolean)painterProperties.get("calculate-cell-height")).booleanValue());
            }
            if (painterProperties.containsKey("calculate-cell-width")) {
                result.setCalculateByWidth(((Boolean)painterProperties.get("calculate-cell-width")).booleanValue());
            }
            return result;
        });
        this.contentPainter.put(CHECKBOX_PAINTER_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            return new CheckBoxPainter(false, invert);
        });
        this.contentPainter.put(COMBOBOX_PAINTER_KEY, (painterProperties, underlying) -> {
            boolean invert = false;
            if (painterProperties.containsKey("invert-icons")) {
                invert = (Boolean)painterProperties.get("invert-icons");
            }
            return new ComboBoxPainter(invert);
        });
        this.contentPainter.put(PASSWORD_PAINTER_KEY, (painterProperties, underlying) -> new PasswordTextPainter(false, false));
        this.contentPainter.put(PERCENTAGEBAR_PAINTER_KEY, (painterProperties, underlying) -> new PercentageBarCellPainter());
        this.contentPainter.put(TABLE_PAINTER_KEY, (painterProperties, underlying) -> {
            TableCellPainter result = new TableCellPainter((ICellPainter)new TextPainter(false, false));
            result.setPaintBg(false);
            return result;
        });
    }

    public ICellPainter getCellPainter(List<String> painterValues, Map<String, Object> painterProperties) {
        String last;
        String backgroundKey = null;
        ArrayList<String> decoratorKeys = new ArrayList<String>();
        String contentKey = null;
        if (this.isBackgroundPainterKey(painterValues.get(0))) {
            backgroundKey = painterValues.get(0);
        }
        if (this.isContentPainterKey(last = painterValues.get(painterValues.size() - 1)) || NONE.equals(last)) {
            contentKey = last;
        }
        int decoratorStart = backgroundKey != null ? 1 : 0;
        int decoratorEnd = contentKey != null ? painterValues.size() - 1 : painterValues.size();
        decoratorKeys.addAll(painterValues.subList(decoratorStart, decoratorEnd));
        return this.getCellPainter(backgroundKey, decoratorKeys, contentKey, painterProperties);
    }

    public ICellPainter getCellPainter(String backgroundKey, List<String> decoratorKeys, String contentKey, Map<String, Object> painterProperties) {
        CellPainterWrapper bgPainter;
        ICellPainter painter = null;
        ICellPainter cp = null;
        if (this.isContentPainterKey(contentKey)) {
            cp = this.getContentPainter(contentKey, painterProperties);
        } else if (!NONE.equalsIgnoreCase(contentKey)) {
            cp = this.getContentPainter(TEXT_PAINTER_KEY, painterProperties);
        }
        painter = cp;
        String decoratorKey = null;
        int i = decoratorKeys.size() - 1;
        while (i >= 0) {
            decoratorKey = decoratorKeys.get(i);
            if (DECORATOR_KEY.equalsIgnoreCase(decoratorKey)) {
                decorator = new CellPainterDecorator();
                decorator.setPaintBackground(false);
                decorator.setBaseCellPainter(painter);
                Image image = (Image)painterProperties.get("decorator-image");
                CellEdgeEnum edge = (CellEdgeEnum)painterProperties.get("decorator-edge");
                Integer spacing = (Integer)painterProperties.get("decorator-spacing");
                Boolean paintDecorationDependent = (Boolean)painterProperties.get("decoration-dependent");
                decorator.setDecoratorCellPainter((ICellPainter)new ImagePainter(image, false));
                decorator.setCellEdge(edge);
                decorator.setSpacing(spacing.intValue());
                decorator.setPaintDecorationDependent(paintDecorationDependent.booleanValue());
                painter = decorator;
            } else {
                decorator = this.getDecoratorPainter(decoratorKey, painterProperties, painter);
                if (decorator != null) {
                    painter = decorator;
                }
            }
            --i;
        }
        if (backgroundKey != null && (bgPainter = this.getBackgroundPainter(backgroundKey, painterProperties, painter)) != null) {
            bgPainter.setWrappedPainter(painter);
            painter = bgPainter;
        }
        return painter;
    }

    public CellPainterWrapper getBackgroundPainter(String key, Map<String, Object> painterProperties, ICellPainter underlying) {
        CellPainterWrapper result = null;
        String lowerKey = key.toLowerCase();
        CellPainterWrapperCreator creator = this.backgroundPainter.get(lowerKey);
        if (creator != null) {
            result = creator.createCellPainterWrapper(painterProperties, underlying);
        }
        return result;
    }

    public CellPainterWrapper getDecoratorPainter(String key, Map<String, Object> painterProperties, ICellPainter underlying) {
        CellPainterWrapper result = null;
        String lowerKey = key.toLowerCase();
        CellPainterWrapperCreator creator = this.decoratorPainter.get(lowerKey);
        if (creator != null) {
            result = creator.createCellPainterWrapper(painterProperties, underlying);
        }
        if (result == null) {
            result = this.getBackgroundPainter(key, painterProperties, underlying);
        }
        return result;
    }

    public ICellPainter getContentPainter(String key, Map<String, Object> painterProperties) {
        ICellPainter result = null;
        String lowerKey = key.toLowerCase();
        CellPainterCreator creator = this.contentPainter.get(lowerKey);
        if (creator != null) {
            result = creator.createCellPainter(painterProperties, null);
        }
        return result;
    }

    public void initTextPainter(AbstractTextPainter painter, Map<String, Object> painterProperties) {
        boolean wrapWord = false;
        if (painterProperties.containsKey("word-wrap")) {
            wrapWord = (Boolean)painterProperties.get("word-wrap");
        }
        painter.setWordWrapping(wrapWord);
        boolean wrapText = false;
        if (painterProperties.containsKey("text-wrap")) {
            wrapText = (Boolean)painterProperties.get("text-wrap");
        }
        painter.setWrapText(wrapText);
        boolean trimText = true;
        if (painterProperties.containsKey("text-trim")) {
            trimText = (Boolean)painterProperties.get("text-trim");
        }
        painter.setTrimText(trimText);
        String textDirection = (String)painterProperties.get("text-direction");
        boolean vertical = false;
        if ("vertical".equalsIgnoreCase(textDirection)) {
            vertical = true;
        }
        int lineSpacing = 0;
        if (painterProperties.containsKey("line-spacing")) {
            lineSpacing = (Integer)painterProperties.get("line-spacing");
        }
        painter.setLineSpacing(lineSpacing);
        boolean calculateHeight = false;
        if (painterProperties.containsKey("calculate-cell-height")) {
            calculateHeight = (Boolean)painterProperties.get("calculate-cell-height");
        }
        boolean calculateWidth = false;
        if (painterProperties.containsKey("calculate-cell-width")) {
            calculateWidth = (Boolean)painterProperties.get("calculate-cell-width");
        }
        if (!vertical) {
            painter.setCalculateByTextHeight(calculateHeight);
            painter.setCalculateByTextLength(calculateWidth);
        } else {
            painter.setCalculateByTextLength(calculateHeight);
            painter.setCalculateByTextHeight(calculateWidth);
        }
    }

    public boolean isBackgroundPainterKey(String key) {
        return key != null && this.backgroundPainter.containsKey(key.toLowerCase());
    }

    public boolean isDecoratorPainterKey(String key) {
        return key != null && this.decoratorPainter.containsKey(key.toLowerCase());
    }

    public boolean isContentPainterKey(String key) {
        return key != null && this.contentPainter.containsKey(key.toLowerCase());
    }

    public void registerBackgroundPainter(String key, CellPainterWrapperCreator creator) {
        this.backgroundPainter.put(key, creator);
    }

    public void registerDecoratorPainter(String key, CellPainterWrapperCreator creator) {
        this.decoratorPainter.put(key, creator);
    }

    public void registerContentPainter(String key, CellPainterCreator creator) {
        this.contentPainter.put(key, creator);
    }
}

