/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformHelper.class);
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private static final boolean IS_RAP = "rap".equals(SWT.getPlatform());
    private static Map<String, Optional<Method>> METHOD_MAPPING = new ConcurrentHashMap<String, Optional<Method>>();

    private PlatformHelper() {
    }

    public static boolean isMAC() {
        return IS_MAC;
    }

    public static boolean isRAP() {
        return IS_RAP;
    }

    public static Object callGetter(Object obj, String methodName) {
        String key = obj.getClass().getName() + "#" + methodName;
        Optional method = METHOD_MAPPING.computeIfAbsent(key, k -> {
            try {
                Method m = obj.getClass().getMethod(methodName, new Class[0]);
                return Optional.of(m);
            }
            catch (IllegalArgumentException | NoSuchMethodException e) {
                return Optional.empty();
            }
        });
        if (method.isPresent()) {
            try {
                return ((Method)method.get()).invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Failed to invoke method \"{}\" on \"{}\"", new Object[]{methodName, obj.getClass().getName(), e});
                return null;
            }
        }
        return null;
    }

    public static void callSetter(Object obj, String methodName, Class<?> parameterType, Object parameterValue) {
        PlatformHelper.callSetter(obj, methodName, new Class[]{parameterType}, new Object[]{parameterValue});
    }

    public static void callSetter(Object obj, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        String key = obj.getClass().getName() + "#" + methodName + "#" + Arrays.toString(parameterTypes);
        Optional method = METHOD_MAPPING.computeIfAbsent(key, k -> {
            try {
                Method m = obj.getClass().getMethod(methodName, parameterTypes);
                return Optional.of(m);
            }
            catch (IllegalArgumentException | NoSuchMethodException e) {
                return Optional.empty();
            }
        });
        if (method.isPresent()) {
            try {
                ((Method)method.get()).invoke(obj, parameterValues);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Failed to invoke method \"{}\" on \"{}\"", new Object[]{methodName, obj.getClass().getName(), e});
            }
        }
    }

    public static String getIDialogConstantsLabel(String label) {
        try {
            if (IDialogConstants.class.isInterface()) {
                return IDialogConstants.class.getField(label).get(null).toString();
            }
            Method get = IDialogConstants.class.getMethod("get", new Class[0]);
            IDialogConstants invoke = (IDialogConstants)get.invoke(null, new Object[0]);
            return invoke.getClass().getField(label).get(invoke).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return "";
        }
    }
}

