/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.pricing;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DelimitedFileReader
extends FilterReader {
    private char delimChar;
    private StringTokenizer tabbedLineRead;

    DelimitedFileReader(Reader reader, char delimeter) {
        super(reader);
        this.delimChar = delimeter;
    }

    @Override
    public int read() throws IOException {
        return this.readLine(new char[1], 0, 1);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.readLine(cbuf, off, len);
    }

    private int readLine(char[] readBuffer, int off, int len) throws IOException {
        int read = -1;
        boolean hasLineBeenRead = false;
        if (this.tabbedLineRead != null) {
            this.in.reset();
        }
        char prevChar = this.delimChar;
        ArrayList<Character> charBuffer = new ArrayList<Character>();
        PushbackReader pushBackReader = new PushbackReader(this.in, len);
        while ((read = pushBackReader.read(readBuffer, off, len)) >= 0) {
            int charIndex = 0;
            while (charIndex < readBuffer.length) {
                char readChar = readBuffer[charIndex];
                if (readChar == '\n') {
                    this.in.mark(read);
                    pushBackReader.unread(readBuffer, 0, readBuffer.length - (charIndex + 1));
                    hasLineBeenRead = true;
                    break;
                }
                if (readChar == this.delimChar && this.delimChar == prevChar) {
                    charBuffer.add(Character.valueOf(' '));
                }
                prevChar = readChar;
                charBuffer.add(Character.valueOf(readChar));
                ++charIndex;
            }
            if (!hasLineBeenRead) continue;
            hasLineBeenRead = false;
            break;
        }
        if (read >= 0) {
            this.tabbedLineRead = new StringTokenizer(this.parseCharactersToString(charBuffer), String.valueOf(this.delimChar));
        }
        return read;
    }

    public StringTokenizer getTabbedLineRead() {
        return this.tabbedLineRead;
    }

    private String parseCharactersToString(List<Character> chars) {
        char[] dataRead = new char[chars.size()];
        int charCounter = 0;
        for (char charRead : chars) {
            dataRead[charCounter++] = charRead;
        }
        return new String(dataRead);
    }
}

