/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.action.MouseMoveAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.mode.AbstractModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.ui.mode.MouseModeEventHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class ConfigurableModeEventHandler
extends AbstractModeEventHandler {
    private List<MouseMoveAction> currentActiveMoveActions = new ArrayList<MouseMoveAction>();

    public ConfigurableModeEventHandler(ModeSupport modeSupport, NatTable natTable) {
        super(modeSupport, natTable);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        IKeyAction keyAction = this.getUiBindingRegistry().getKeyEventAction(event);
        if (keyAction != null) {
            this.natTable.forceFocus();
            keyAction.run(this.natTable, event);
        }
    }

    @Override
    public void mouseDown(MouseEvent event) {
        if (this.natTable.commitAndCloseActiveCellEditor()) {
            IMouseAction mouseDownAction = this.getUiBindingRegistry().getMouseDownAction(event);
            if (mouseDownAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseDownAction.run(this.natTable, event);
            }
            IMouseAction singleClickAction = this.getUiBindingRegistry().getSingleClickAction(event);
            IMouseAction doubleClickAction = this.getUiBindingRegistry().getDoubleClickAction(event);
            IDragMode dragMode = this.getUiBindingRegistry().getDragMode(event);
            if (singleClickAction != null || doubleClickAction != null || dragMode != null) {
                this.switchMode(new MouseModeEventHandler(this.getModeSupport(), this.natTable, event, singleClickAction, doubleClickAction, dragMode));
            }
        }
    }

    @Override
    public synchronized void mouseMove(MouseEvent event) {
        if (event.x >= 0 && event.y >= 0) {
            event.data = NatEventData.createInstanceFromEvent(event);
            LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
            Iterator<MouseMoveAction> it = this.currentActiveMoveActions.iterator();
            while (it.hasNext()) {
                MouseMoveAction currentAction = it.next();
                boolean matches = currentAction.mouseEventMatcher.matches(this.natTable, event, regionLabels);
                if (matches && currentAction.reexecuteEntryAction) {
                    currentAction.run(this.natTable, event);
                    continue;
                }
                if (matches) continue;
                currentAction.runExit(this.natTable, event);
                it.remove();
            }
            IMouseAction mouseMoveAction = this.getUiBindingRegistry().getMouseMoveAction(event);
            if (mouseMoveAction != null) {
                if (mouseMoveAction instanceof MouseMoveAction && !this.currentActiveMoveActions.contains(mouseMoveAction)) {
                    mouseMoveAction.run(this.natTable, event);
                    this.currentActiveMoveActions.add((MouseMoveAction)mouseMoveAction);
                } else if (!(mouseMoveAction instanceof MouseMoveAction)) {
                    mouseMoveAction.run(this.natTable, event);
                }
            } else {
                this.natTable.setCursor(null);
            }
        }
    }

    @Override
    public synchronized void mouseHover(MouseEvent event) {
        IMouseAction mouseHoverAction;
        if (event.x >= 0 && event.y >= 0 && (mouseHoverAction = this.getUiBindingRegistry().getMouseHoverAction(event)) != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            mouseHoverAction.run(this.natTable, event);
        }
    }

    @Override
    public synchronized void mouseEnter(MouseEvent event) {
        if (event.x >= 0 && event.y >= 0) {
            IMouseAction mouseEnterAction = this.getUiBindingRegistry().getMouseEnterAction(event);
            if (mouseEnterAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseEnterAction.run(this.natTable, event);
            } else {
                this.natTable.setCursor(null);
            }
        }
    }

    @Override
    public synchronized void mouseExit(MouseEvent event) {
        event.data = NatEventData.createInstanceFromEvent(event);
        this.currentActiveMoveActions.forEach(action -> action.runExit(this.natTable, event));
        this.currentActiveMoveActions.clear();
        IMouseAction mouseExitAction = this.getUiBindingRegistry().getMouseExitAction(event);
        if (mouseExitAction != null) {
            mouseExitAction.run(this.natTable, event);
        } else {
            this.natTable.setCursor(null);
        }
    }

    private UiBindingRegistry getUiBindingRegistry() {
        return this.natTable.getUiBindingRegistry();
    }
}

