/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell.decorator;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CustomLineBorderDecorator
extends CellPainterWrapper {
    public static final String TOP_LINE_BORDER_LABEL = "topLineBorderLabel";
    public static final String BOTTOM_LINE_BORDER_LABEL = "bottomLineBorderLabel";
    public static final String LEFT_LINE_BORDER_LABEL = "leftLineBorderLabel";
    public static final String RIGHT_LINE_BORDER_LABEL = "rightLineBorderLabel";
    private final BorderStyle defaultBorderStyle;

    public CustomLineBorderDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, null);
    }

    public CustomLineBorderDecorator(ICellPainter interiorPainter, BorderStyle defaultBorderStyle) {
        super(interiorPainter);
        this.defaultBorderStyle = defaultBorderStyle;
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        int borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        int borderLineCount = 0;
        LabelStack labels = cell.getConfigLabels();
        if (labels.contains(RIGHT_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        if (labels.contains(LEFT_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        return super.getPreferredWidth(cell, gc, configRegistry) + borderThickness * borderLineCount;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        int borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        int borderLineCount = 0;
        LabelStack labels = cell.getConfigLabels();
        if (labels.contains(TOP_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        if (labels.contains(BOTTOM_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        return super.getPreferredHeight(cell, gc, configRegistry) + borderThickness * borderLineCount;
    }

    private BorderStyle getBorderStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        BorderStyle borderStyle = cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE);
        if (borderStyle == null) {
            borderStyle = this.defaultBorderStyle;
        }
        return borderStyle;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        int borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        LabelStack labels = cell.getConfigLabels();
        int leftBorderThickness = 0;
        int rightBorderThickness = 0;
        int topBorderThickness = 0;
        int bottomBorderThickness = 0;
        if (labels.contains(LEFT_LINE_BORDER_LABEL)) {
            leftBorderThickness = borderThickness;
        }
        if (labels.contains(RIGHT_LINE_BORDER_LABEL)) {
            rightBorderThickness = borderThickness;
        }
        if (labels.contains(TOP_LINE_BORDER_LABEL)) {
            topBorderThickness = borderThickness;
        }
        if (labels.contains(BOTTOM_LINE_BORDER_LABEL)) {
            bottomBorderThickness = borderThickness;
        }
        Rectangle interiorBounds = new Rectangle(rectangle.x + leftBorderThickness, rectangle.y + topBorderThickness, rectangle.width - leftBorderThickness - rightBorderThickness, rectangle.height - topBorderThickness - bottomBorderThickness);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        if (borderStyle == null || borderThickness <= 0 || leftBorderThickness == 0 && rightBorderThickness == 0 && topBorderThickness == 0 && bottomBorderThickness == 0) {
            return;
        }
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        int originalLineStyle = gc.getLineStyle();
        Integer gridLineWidth = configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, DisplayMode.NORMAL, (List<String>)cell.getConfigLabels());
        int adjustment = gridLineWidth == null || gridLineWidth == 1 ? 0 : Math.round(gridLineWidth.floatValue() / 2.0f);
        gc.setLineWidth(borderThickness);
        Rectangle borderArea = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (borderThickness >= 1) {
            int shift = 0;
            int correction = 0;
            if (borderThickness % 2 == 0) {
                shift = borderThickness / 2;
            } else {
                shift = borderThickness / 2;
                correction = 1;
            }
            if (leftBorderThickness >= 1) {
                borderArea.x += shift + adjustment;
                borderArea.width -= shift + adjustment;
            }
            if (rightBorderThickness >= 1) {
                borderArea.width -= shift + correction;
            }
            if (topBorderThickness >= 1) {
                borderArea.y += shift + adjustment;
                borderArea.height -= shift + adjustment;
            }
            if (bottomBorderThickness >= 1) {
                borderArea.height -= shift + correction;
            }
        }
        gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
        gc.setForeground(borderStyle.getColor());
        if (leftBorderThickness > 0 && rightBorderThickness > 0 && topBorderThickness > 0 && bottomBorderThickness > 0) {
            gc.drawRectangle(borderArea);
        } else {
            Point topLeftPos = new Point(borderArea.x, borderArea.y);
            Point topRightPos = new Point(borderArea.x + borderArea.width, borderArea.y);
            Point bottomLeftPos = new Point(borderArea.x, borderArea.y + borderArea.height);
            Point bottomRightPos = new Point(borderArea.x + borderArea.width, borderArea.y + borderArea.height);
            if (leftBorderThickness > 0) {
                gc.drawLine(topLeftPos.x, topLeftPos.y, bottomLeftPos.x, bottomLeftPos.y);
            }
            if (rightBorderThickness > 0) {
                gc.drawLine(topRightPos.x, topRightPos.y, bottomRightPos.x, bottomRightPos.y);
            }
            if (topBorderThickness > 0) {
                gc.drawLine(topLeftPos.x, topLeftPos.y, topRightPos.x, topRightPos.y);
            }
            if (bottomBorderThickness > 0) {
                gc.drawLine(bottomLeftPos.x, bottomLeftPos.y, bottomRightPos.x, bottomRightPos.y);
            }
        }
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
        gc.setLineStyle(originalLineStyle);
    }
}

