/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ColumnStructuralChangeEvent
extends ColumnVisualChangeEvent
implements IStructuralChangeEvent {
    public ColumnStructuralChangeEvent(ILayer layer, Range ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnStructuralChangeEvent(ILayer layer, Collection<Range> columnPositionRanges) {
        super(layer, columnPositionRanges);
    }

    public ColumnStructuralChangeEvent(ILayer layer, Collection<Range> columnPositionRanges, Collection<Integer> columnIndexes) {
        super(layer, columnPositionRanges, columnIndexes);
    }

    public ColumnStructuralChangeEvent(ILayer layer, Collection<Range> columnPositionRanges, int ... columnIndexes) {
        super(layer, columnPositionRanges, columnIndexes);
    }

    protected ColumnStructuralChangeEvent(ColumnStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        ArrayList<Rectangle> changedPositionRectangles = new ArrayList<Rectangle>();
        Collection<Range> ranges = this.getColumnPositionRanges();
        if (ranges != null && !ranges.isEmpty()) {
            int leftmostColumnPosition = Integer.MAX_VALUE;
            for (Range range : ranges) {
                if (range.start >= leftmostColumnPosition) continue;
                leftmostColumnPosition = range.start;
            }
            int columnCount = this.getLayer().getColumnCount();
            int rowCount = this.getLayer().getRowCount();
            changedPositionRectangles.add(new Rectangle(leftmostColumnPosition, 0, columnCount - leftmostColumnPosition, rowCount));
        }
        return changedPositionRectangles;
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return true;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return false;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        return null;
    }
}

