/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.hideshow.indicator.HideIndicatorOverlayPainter;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTreeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class HierarchicalHideIndicatorOverlayPainter
extends HideIndicatorOverlayPainter {
    protected HierarchicalTreeLayer treeLayer;

    public HierarchicalHideIndicatorOverlayPainter(ILayer columnHeaderLayer, HierarchicalTreeLayer treeLayer) {
        this(columnHeaderLayer, null, treeLayer);
    }

    public HierarchicalHideIndicatorOverlayPainter(ILayer columnHeaderLayer, ILayer rowHeaderLayer, HierarchicalTreeLayer treeLayer) {
        super(columnHeaderLayer, rowHeaderLayer);
        this.treeLayer = treeLayer;
    }

    @Override
    protected void paintHiddenColumnIndicator(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        if (this.columnHeaderLayer != null) {
            int lineAdjustment = gc.getLineWidth() % 2;
            int height = this.columnHeaderLayer.getHeight();
            int col = 0;
            while (col < layer.getColumnCount()) {
                int rightPos;
                int rightIndex;
                int rightLevel;
                int leftLevel;
                int currentLevel;
                LabelStack configLabels = layer.getConfigLabelsByPosition(col, this.columnHeaderLayer.getRowCount());
                if (configLabels.hasLabel("COLUMN_LEFT_HIDDEN") && (currentLevel = this.treeLayer.getLevelByColumnIndex(layer.getColumnIndexByPosition(col))) == (leftLevel = this.treeLayer.getLevelByColumnIndex(layer.getColumnIndexByPosition(col - 1)))) {
                    int x = layer.getStartXOfColumnPosition(col);
                    if (this.rowHeaderLayer == null || x >= this.rowHeaderLayer.getWidth()) {
                        int start = rectangle.y;
                        int i = 0;
                        while (i < this.columnHeaderLayer.getRowCount()) {
                            ILayerCell cell = layer.getCellByPosition(col, i);
                            int cellStart = layer.getStartXOfColumnPosition(cell.getOriginColumnPosition());
                            if (cellStart < x && (this.rowHeaderLayer != null && x > this.rowHeaderLayer.getWidth() || this.rowHeaderLayer == null && x > 0)) {
                                start += layer.getRowHeightByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(x - lineAdjustment, start, x - lineAdjustment, height);
                    }
                }
                if (configLabels.hasLabel("COLUMN_RIGHT_HIDDEN") && ((currentLevel = this.treeLayer.getLevelByColumnIndex(layer.getColumnIndexByPosition(col))) == (rightLevel = this.treeLayer.getLevelByColumnIndex(rightIndex = layer.getColumnIndexByPosition(rightPos = LayerUtil.convertColumnPosition(layer, col + 1, this.treeLayer)))) || rightIndex < 0 && !this.treeLayer.isLevelHeaderColumn(rightPos))) {
                    int x = layer.getStartXOfColumnPosition(col) + layer.getColumnWidthByPosition(col);
                    if (col == layer.getColumnCount() - 1) {
                        lineAdjustment = gc.getLineWidth() / 2 + lineAdjustment;
                    }
                    if (this.rowHeaderLayer == null || x >= this.rowHeaderLayer.getWidth()) {
                        int start = rectangle.y;
                        int i = 0;
                        while (i < this.columnHeaderLayer.getRowCount()) {
                            ILayerCell cell = layer.getCellByPosition(col + 1, i);
                            if (cell != null && cell.getOriginColumnPosition() < cell.getColumnPosition() && x < cell.getBounds().x + cell.getBounds().width) {
                                start += layer.getRowHeightByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(x - lineAdjustment, start, x - lineAdjustment, height - 1);
                    }
                }
                ++col;
            }
        }
    }

    @Override
    protected void paintHiddenRowIndicator(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        super.paintHiddenRowIndicator(layer, gc, xOffset, yOffset, rectangle);
        int lineAdjustment = gc.getLineWidth() % 2;
        int startRow = this.columnHeaderLayer == null ? 0 : this.columnHeaderLayer.getRowCount();
        int col = 0;
        while (col < layer.getColumnCount()) {
            LabelStack labels = layer.getConfigLabelsByPosition(col, startRow);
            if (labels.hasLabel("LEVEL_HEADER_CELL")) {
                int row = startRow;
                while (row < layer.getRowCount()) {
                    int startX;
                    ILayerCell cell;
                    int cellStart;
                    int y;
                    LabelStack configLabels = layer.getConfigLabelsByPosition(col + 1, row);
                    if (configLabels.hasLabel("ROW_TOP_HIDDEN")) {
                        y = layer.getStartYOfRowPosition(row);
                        if ((this.columnHeaderLayer == null || y >= this.columnHeaderLayer.getHeight()) && (cellStart = layer.getStartYOfRowPosition((cell = layer.getCellByPosition(col, row)).getOriginRowPosition())) == y) {
                            startX = layer.getStartXOfColumnPosition(col);
                            gc.drawLine(startX, y - lineAdjustment, startX + layer.getColumnWidthByPosition(col), y - lineAdjustment);
                        }
                    }
                    if (configLabels.hasLabel("ROW_BOTTOM_HIDDEN")) {
                        y = layer.getStartYOfRowPosition(row) + layer.getRowHeightByPosition(row);
                        if (row == layer.getRowCount() - 1) {
                            lineAdjustment = gc.getLineWidth() / 2 + lineAdjustment;
                        }
                        if ((this.columnHeaderLayer == null || y >= this.columnHeaderLayer.getHeight()) && (cellStart = layer.getStartYOfRowPosition((cell = layer.getCellByPosition(col, row)).getOriginRowPosition())) == y) {
                            startX = layer.getStartXOfColumnPosition(col);
                            gc.drawLine(startX, y - lineAdjustment, startX + layer.getColumnWidthByPosition(col), y - lineAdjustment);
                        }
                    }
                    ++row;
                }
            }
            ++col;
        }
    }
}

