/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.AutoResizeColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.AutoResizeRowCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultGridLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.PrintCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeRowsCommand;
import org.eclipse.swt.graphics.Rectangle;

public class GridLayer
extends CompositeLayer {
    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer) {
        this(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer, true);
    }

    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.setBodyLayer(bodyLayer);
        this.setColumnHeaderLayer(columnHeaderLayer);
        this.setRowHeaderLayer(rowHeaderLayer);
        this.setCornerLayer(cornerLayer);
        this.init(useDefaultConfiguration);
    }

    protected GridLayer(boolean useDefaultConfiguration) {
        super(2, 2);
        this.init(useDefaultConfiguration);
    }

    protected void init(boolean useDefaultConfiguration) {
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultGridLayerConfiguration(this));
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PrintCommandHandler(this));
        this.registerCommandHandler(new ExportCommandHandler(this));
        this.registerCommandHandler(new AutoResizeColumnCommandHandler(this));
        this.registerCommandHandler(new AutoResizeRowCommandHandler(this));
    }

    @Override
    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        if (this.doCommandOnChildLayer(command, this.getBodyLayer())) {
            return true;
        }
        if (this.doCommandOnChildLayer(command, this.getColumnHeaderLayer())) {
            return true;
        }
        if (this.doCommandOnChildLayer(command, this.getRowHeaderLayer())) {
            return true;
        }
        return this.doCommandOnChildLayer(command, this.getCornerLayer());
    }

    private boolean doCommandOnChildLayer(ILayerCommand command, ILayer childLayer) {
        ILayerCommand childCommand = command.cloneCommand();
        return childLayer.doCommand(childCommand);
    }

    public ILayer getCornerLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 0);
    }

    public void setCornerLayer(ILayer cornerLayer) {
        this.setChildLayer("CORNER", cornerLayer, 0, 0);
    }

    public ILayer getColumnHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 0);
    }

    public void setColumnHeaderLayer(ILayer columnHeaderLayer) {
        this.setChildLayer("COLUMN_HEADER", columnHeaderLayer, 1, 0);
    }

    public ILayer getRowHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 1);
    }

    public void setRowHeaderLayer(ILayer rowHeaderLayer) {
        this.setChildLayer("ROW_HEADER", rowHeaderLayer, 0, 1);
    }

    public ILayer getBodyLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 1);
    }

    public void setBodyLayer(ILayer bodyLayer) {
        this.setChildLayer("BODY", bodyLayer, 1, 1);
        this.unregisterCommandHandler(AutoResizeColumnsCommand.class);
        this.unregisterCommandHandler(AutoResizeRowsCommand.class);
        this.registerCommandHandler(new AutoResizeColumnCommandHandler(this));
        this.registerCommandHandler(new AutoResizeRowCommandHandler(this));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[corner=" + String.valueOf(this.getCornerLayer()) + " columnHeader=" + String.valueOf(this.getColumnHeaderLayer()) + " rowHeader=" + String.valueOf(this.getRowHeaderLayer()) + " bodyLayer=" + String.valueOf(this.getBodyLayer()) + "]";
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            Rectangle possibleArea = clientAreaResizeCommand.getScrollable().getClientArea();
            Rectangle rowLayerArea = this.getRowHeaderLayer().getClientAreaProvider().getClientArea();
            Rectangle columnLayerArea = this.getColumnHeaderLayer().getClientAreaProvider().getClientArea();
            possibleArea.width -= rowLayerArea.width;
            possibleArea.height -= columnLayerArea.height;
            clientAreaResizeCommand.setCalcArea(possibleArea);
        }
        return super.doCommand(command);
    }
}

