/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.IndexCoordinate;
import org.eclipse.nebula.widgets.nattable.formula.FormulaErrorReporter;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.swt.widgets.Event;

public class FormulaTooltipErrorReporter
extends NatTableContentTooltip
implements FormulaErrorReporter {
    protected Map<IndexCoordinate, String> formulaErrors = new HashMap<IndexCoordinate, String>();
    protected IUniqueIndexLayer bodyDataLayer;

    public FormulaTooltipErrorReporter(NatTable natTable, IUniqueIndexLayer bodyDataLayer) {
        this(natTable, bodyDataLayer, "BODY");
    }

    public FormulaTooltipErrorReporter(NatTable natTable, IUniqueIndexLayer bodyDataLayer, String ... tooltipRegions) {
        super(natTable, tooltipRegions);
        this.bodyDataLayer = bodyDataLayer;
    }

    @Override
    protected String getText(Event event) {
        int rowIdx;
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        int colIdx = LayerUtil.convertColumnPosition(this.natTable, col, this.bodyDataLayer);
        IndexCoordinate coord = new IndexCoordinate(colIdx, rowIdx = LayerUtil.convertRowPosition(this.natTable, row, this.bodyDataLayer));
        if (this.formulaErrors.containsKey(coord)) {
            return this.formulaErrors.get(coord);
        }
        return null;
    }

    @Override
    public void addFormulaError(int column, int row, String message) {
        this.formulaErrors.put(new IndexCoordinate(column, row), message);
    }

    @Override
    public void clearFormulaError(int column, int row) {
        this.formulaErrors.remove(new IndexCoordinate(column, row));
    }

    @Override
    public boolean hasFormulaError(int column, int row) {
        return this.formulaErrors.containsKey(new IndexCoordinate(column, row));
    }

    @Override
    public String getFormulaError(int column, int row) {
        return this.formulaErrors.get(new IndexCoordinate(column, row));
    }
}

