/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.ByteObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionImmutableBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.BiMaps;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.SortedMaps;
import org.eclipse.collections.impl.factory.SortedSets;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.ObjectByteMaps;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.lazy.LazyIterableAdapter;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableByteObjectMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteObjectEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

final class ImmutableByteObjectSingletonMap<V>
extends AbstractImmutableByteObjectMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte key1;
    private final V value1;

    ImmutableByteObjectSingletonMap(byte key1, V value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public V get(byte key) {
        return this.key1 == key ? (V)this.value1 : null;
    }

    public V getIfAbsent(byte key, Function0<? extends V> ifAbsent) {
        return (V)(this.key1 == key ? this.value1 : ifAbsent.value());
    }

    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    public boolean containsValue(Object value) {
        return ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, value);
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableByteObjectMap<V> tap(Procedure<? super V> procedure) {
        procedure.value(this.value1);
        return this;
    }

    public void forEachValue(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteObjectProcedure<? super V> procedure) {
        procedure.value(this.key1, this.value1);
    }

    public ImmutableByteObjectMap<V> select(ByteObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableByteObjectEmptyMap.INSTANCE;
    }

    public ImmutableByteObjectMap<V> reject(ByteObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? ImmutableByteObjectEmptyMap.INSTANCE : ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableByteObjectMap<V> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    public Collection<V> values() {
        return Lists.immutable.of(this.value1).castToList();
    }

    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ByteObjectPair<V>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableObjectByteMap<V> flipUniqueValues() {
        return ObjectByteMaps.immutable.with(this.value1, this.key1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap map = (ByteObjectMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, map.get(this.key1));
    }

    public int hashCode() {
        return this.key1 ^ (this.value1 == null ? 0 : this.value1.hashCode());
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public V getFirst() {
        return this.value1;
    }

    public V getLast() {
        return this.value1;
    }

    public V getOnly() {
        return this.value1;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        Iterator<?> iterator = source.iterator();
        while (iterator.hasNext()) {
            if (ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public ImmutableBag<V> select(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Bags.immutable.with(this.value1) : Bags.immutable.with();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P> ImmutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? Bags.immutable.with(this.value1) : Bags.immutable.with();
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public ImmutableBag<V> reject(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Bags.immutable.with() : Bags.immutable.with(this.value1);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (!predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P> ImmutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? Bags.immutable.with() : Bags.immutable.with(this.value1);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (!predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public PartitionImmutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag.toImmutable();
    }

    public <P> PartitionImmutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionMutableBag));
        return partitionMutableBag.toImmutable();
    }

    public <S> ImmutableBag<S> selectInstancesOf(Class<S> clazz) {
        return clazz.isInstance(this.value1) ? Bags.immutable.with(clazz.cast(this.value1)) : Bags.immutable.with();
    }

    public <VV> ImmutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return Bags.immutable.with(function.valueOf(this.value1));
    }

    public ImmutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return BooleanBags.immutable.with(booleanFunction.booleanValueOf(this.value1));
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        target.add(booleanFunction.booleanValueOf(this.value1));
        return target;
    }

    public ImmutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return ByteBags.immutable.with(byteFunction.byteValueOf(this.value1));
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        target.add(byteFunction.byteValueOf(this.value1));
        return target;
    }

    public ImmutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return CharBags.immutable.with(charFunction.charValueOf(this.value1));
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        target.add(charFunction.charValueOf(this.value1));
        return target;
    }

    public ImmutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return DoubleBags.immutable.with(doubleFunction.doubleValueOf(this.value1));
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        target.add(doubleFunction.doubleValueOf(this.value1));
        return target;
    }

    public ImmutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return FloatBags.immutable.with(floatFunction.floatValueOf(this.value1));
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        target.add(floatFunction.floatValueOf(this.value1));
        return target;
    }

    public ImmutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return IntBags.immutable.with(intFunction.intValueOf(this.value1));
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        target.add(intFunction.intValueOf(this.value1));
        return target;
    }

    public ImmutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return LongBags.immutable.with(longFunction.longValueOf(this.value1));
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        target.add(longFunction.longValueOf(this.value1));
        return target;
    }

    public ImmutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return ShortBags.immutable.with(shortFunction.shortValueOf(this.value1));
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        target.add(shortFunction.shortValueOf(this.value1));
        return target;
    }

    public <VV> ImmutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return predicate.accept(this.value1) ? Bags.immutable.with(function.valueOf(this.value1)) : Bags.immutable.with();
    }

    public <VV> ImmutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return Bags.immutable.withAll((Iterable)function.valueOf(this.value1));
    }

    public V detect(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? (V)this.value1 : null;
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? (V)this.value1 : null;
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Optional.of(this.value1) : Optional.empty();
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? Optional.of(this.value1) : Optional.empty();
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)(predicate.accept(this.value1) ? this.value1 : function.value());
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)(predicate.accept(this.value1, parameter) ? this.value1 : function.value());
    }

    public int count(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? 1 : 0;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !predicate.accept(this.value1);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return !predicate.accept(this.value1, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)function.value(injectedValue, this.value1);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return function.intValueOf(injectedValue, this.value1);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return function.longValueOf(injectedValue, this.value1);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return function.floatValueOf(injectedValue, this.value1);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return function.doubleValueOf(injectedValue, this.value1);
    }

    public <R extends Collection<V>> R into(R target) {
        return Iterate.addAllTo(this, target);
    }

    public MutableList<V> toList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableSet<V> toSet() {
        return Sets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet() {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableBag<V> toBag() {
        return Bags.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedBag<V> toSortedBag() {
        return TreeBag.newBagWith(this.value1);
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return TreeBag.newBagWith(comparator, this.value1);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return Maps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return BiMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public LazyIterable<V> asLazy() {
        return new LazyIterableAdapter(Lists.mutable.with(new Object[]{this.value1}));
    }

    public Object[] toArray() {
        return new Object[]{this.value1};
    }

    public <T> T[] toArray(T[] a) {
        return new Object[]{this.value1};
    }

    public V min(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V max(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V min() {
        return this.value1;
    }

    public V max() {
        return this.value1;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return function.intValueOf(this.value1);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return function.floatValueOf(this.value1);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return function.longValueOf(this.value1);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return function.doubleValueOf(this.value1);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <VV> ImmutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return Multimaps.immutable.bag.with(function.valueOf(this.value1), this.value1);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        target.put(function.valueOf(this.value1), this.value1);
        return target;
    }

    public <VV> ImmutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Iterable iterable = (Iterable)function.valueOf(this.value1);
        for (Object key : iterable) {
            target.put(key, this.value1);
        }
        return target;
    }

    public <VV> ImmutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return Maps.immutable.with(function.valueOf(this.value1), this.value1);
    }

    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (target.put(function.valueOf(this.value1), this.value1) != null) {
            throw new IllegalStateException("Key " + function.valueOf(this.value1) + " already exists in map!");
        }
        return target;
    }

    public <S> ImmutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag()).toImmutable();
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public ImmutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)UnifiedSet.newSet())).toImmutable();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.of();
        result.add((Object)Lists.mutable.with(new Object[]{this.value1}));
        return result;
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return this.value1;
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return this.value1;
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return Lists.mutable.of(new Object[]{this.value1});
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Iterate.addAllTo((Iterable)function.valueOf(this.value1), target);
        return target;
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (predicate.accept(this.value1)) {
            target.add((Object)function.valueOf(this.value1));
        }
        return target;
    }

    public <P, VV> ImmutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return Bags.immutable.with(function.value(this.value1, parameter));
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        targetCollection.add((Object)function.value(this.value1, parameter));
        return targetCollection;
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        target.add((Object)function.valueOf(this.value1));
        return target;
    }

    public ImmutableByteObjectMap<V> newWithKeyValue(byte key, V value) {
        return ByteObjectHashMap.newWithKeysValues(this.key1, this.value1, key, value).toImmutable();
    }

    public ImmutableByteObjectMap<V> newWithoutKey(byte key) {
        return this.key1 == key ? ImmutableByteObjectEmptyMap.INSTANCE : this;
    }

    public ImmutableByteObjectMap<V> newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ImmutableByteObjectEmptyMap.INSTANCE : this;
    }

    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    public void each(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        objectIntProcedure.value(this.value1, 0);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        procedure.value(this.value1, parameter);
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter<V>(ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).iterator());
    }

    private Object writeReplace() {
        return new AbstractImmutableByteObjectMap.ImmutableByteObjectMapSerializationProxy(this);
    }
}

