/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

public abstract class AbstractTreeRowModel<T>
implements ITreeRowModel<T> {
    private final HashSet<ITreeRowModelListener> listeners = new HashSet();
    private final ITreeData<T> treeData;

    public AbstractTreeRowModel(ITreeData<T> treeData) {
        this.treeData = treeData;
    }

    public void registerRowGroupModelListener(ITreeRowModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (ITreeRowModelListener listener : this.listeners) {
            listener.treeRowModelChanged();
        }
    }

    @Override
    public int depth(int index) {
        return this.getTreeData().getDepthOfData(index);
    }

    @Override
    public boolean isLeaf(int index) {
        return !this.hasChildren(index);
    }

    @Override
    public boolean hasChildren(int index) {
        return this.treeData.hasChildren(index);
    }

    @Override
    public boolean isCollapsed(T object) {
        return this.isCollapsed((T)this.getTreeData().indexOf(object));
    }

    @Override
    public boolean isCollapsible(int index) {
        return this.hasChildren(index);
    }

    @Override
    public List<Integer> collapse(T object) {
        return this.collapse((T)this.getTreeData().indexOf(object));
    }

    @Override
    public List<Integer> expand(T object) {
        return this.expand((T)this.getTreeData().indexOf(object));
    }

    @Override
    public List<Integer> expandToLevel(T object, int level) {
        return this.expandToLevel((T)this.getTreeData().indexOf(object), level);
    }

    @Override
    public List<Integer> getChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<int> children = this.getDirectChildren((T)parentIndex);
        for (Object object : children) {
            int index = this.treeData.indexOf(object);
            if (index < 0) continue;
            result.add(index);
            result.addAll(this.getChildIndexes(index));
        }
        return result;
    }

    @Override
    public List<Integer> getDirectChildIndexes(int parentIndex) {
        List<int> children = this.getDirectChildren((T)parentIndex);
        ArrayList<Integer> result = new ArrayList<Integer>(children.size());
        for (Object object : children) {
            int index = this.treeData.indexOf(object);
            if (index < 0) continue;
            result.add(index);
        }
        return result;
    }

    @Override
    public List<T> getChildren(int parentIndex) {
        return this.getChildren(this.treeData.getDataAtIndex(parentIndex));
    }

    protected List<T> getChildren(T parent) {
        ArrayList<T> result = new ArrayList<T>();
        List<T> children = this.getDirectChildren(parent);
        for (T child : children) {
            result.add(child);
            result.addAll(this.getChildren(child));
        }
        return result;
    }

    @Override
    public List<T> getDirectChildren(int parentIndex) {
        return this.treeData.getChildren(parentIndex);
    }

    protected List<T> getDirectChildren(T parent) {
        return this.treeData.getChildren(parent);
    }

    public ITreeData<T> getTreeData() {
        return this.treeData;
    }
}

