/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractColumnCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class ViewportSelectColumnGroupCommand
extends AbstractColumnCommand {
    private int originColumnPosition;
    private final int columnSpan;
    private final boolean withShiftMask;
    private final boolean withControlMask;

    public ViewportSelectColumnGroupCommand(ILayer layer, int columnPosition, int originColumnPosition, int columnSpan, boolean withShiftMask, boolean withControlMask) {
        super(layer, columnPosition);
        this.originColumnPosition = originColumnPosition;
        this.columnSpan = columnSpan;
        this.withShiftMask = withShiftMask;
        this.withControlMask = withControlMask;
    }

    protected ViewportSelectColumnGroupCommand(ViewportSelectColumnGroupCommand command) {
        super(command);
        this.originColumnPosition = command.originColumnPosition;
        this.columnSpan = command.columnSpan;
        this.withShiftMask = command.withShiftMask;
        this.withControlMask = command.withControlMask;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        int prev = this.getColumnPosition();
        if (super.convertToTargetLayer(targetLayer)) {
            this.originColumnPosition -= prev - this.getColumnPosition();
            return true;
        }
        return false;
    }

    public int getOriginColumnPosition() {
        return this.originColumnPosition;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public boolean isWithShiftMask() {
        return this.withShiftMask;
    }

    public boolean isWithControlMask() {
        return this.withControlMask;
    }

    @Override
    public ViewportSelectColumnGroupCommand cloneCommand() {
        return new ViewportSelectColumnGroupCommand(this);
    }
}

