/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.datachange.AbstractDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChange;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeLayer;
import org.eclipse.nebula.widgets.nattable.datachange.UpdateDataChange;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public abstract class UpdateDataChangeHandler<T extends UpdateDataChange>
extends AbstractDataChangeHandler<T> {
    protected final Set<Integer> changedColumns = new HashSet<Integer>();
    protected final Set<Integer> changedRows = new HashSet<Integer>();
    private boolean updateOnHorizontalChanges = true;
    private boolean updateOnVerticalChanges = true;

    public UpdateDataChangeHandler(DataChangeLayer layer, CellKeyHandler<?> keyHandler, Map<Object, T> dataChanges) {
        super(layer, keyHandler, dataChanges);
    }

    @Override
    public void handleStructuralChange(IStructuralChangeEvent structuralChangeEvent) {
        if (structuralChangeEvent.isHorizontalStructureChanged() && structuralChangeEvent.getColumnDiffs() != null) {
            if (this.keyHandler.updateOnHorizontalStructuralChange()) {
                Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getColumnDiffs();
                this.handleColumnDelete(structuralDiffs);
                this.handleColumnInsert(structuralDiffs);
            } else {
                this.removeChangesForDeletedColumnObjects();
            }
        } else if (structuralChangeEvent.isVerticalStructureChanged() && structuralChangeEvent.getRowDiffs() != null) {
            if (this.keyHandler.updateOnVerticalStructuralChange()) {
                Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getRowDiffs();
                this.handleRowDelete(structuralDiffs);
                this.handleRowInsert(structuralDiffs);
            } else {
                this.removeChangesForDeletedRowObjects();
            }
        }
        this.rebuildPositionCollections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRowDelete(Collection<StructuralDiff> rowDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(rowDiffs);
        Collections.sort(diffs, (o1, o2) -> o1.getBeforePositionRange().start - o2.getBeforePositionRange().start);
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff rowDiff : diffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                }
                ++i;
            }
        }
        if (!toRemove.isEmpty()) {
            HashMap modifiedRows = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int rowIndex = this.keyHandler.getRowIndex(entry.getKey());
                if (!toRemove.contains(rowIndex)) {
                    int deletedBefore = 0;
                    for (Integer removed : toRemove) {
                        if (removed >= rowIndex) continue;
                        ++deletedBefore;
                    }
                    int modRow = rowIndex - deletedBefore;
                    if (modRow < 0) continue;
                    Object oldKey = entry.getKey();
                    Object updatedKey = this.keyHandler.getKeyWithRowUpdate(oldKey, modRow);
                    ((UpdateDataChange)entry.getValue()).updateKey(updatedKey);
                    modifiedRows.put(updatedKey, (UpdateDataChange)entry.getValue());
                    if (!this.updateOnVerticalChanges) continue;
                    List<DataChange> list = this.layer.dataChanges;
                    synchronized (list) {
                        for (DataChange change : this.layer.dataChanges) {
                            if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || !change.getKey().equals(oldKey)) continue;
                            Object uk = this.keyHandler.getKeyWithRowUpdate(oldKey, modRow);
                            change.updateKey(uk);
                        }
                        continue;
                    }
                }
                if (!this.updateOnVerticalChanges) continue;
                List<DataChange> list = this.layer.dataChanges;
                synchronized (list) {
                    Iterator<DataChange> it = this.layer.dataChanges.iterator();
                    while (it.hasNext()) {
                        DataChange change = it.next();
                        if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || this.keyHandler.getRowIndex(change.getKey()) != this.keyHandler.getRowIndex(((UpdateDataChange)entry.getValue()).getKey())) continue;
                        it.remove();
                    }
                }
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRowInsert(Collection<StructuralDiff> rowDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(rowDiffs);
        Collections.sort(diffs, (o1, o2) -> o2.getBeforePositionRange().start - o1.getBeforePositionRange().start);
        for (StructuralDiff rowDiff : diffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            HashMap modifiedRows = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int rowIndex = this.keyHandler.getRowIndex(entry.getKey());
                Object oldKey = entry.getKey();
                int modRow = -1;
                modRow = rowIndex >= beforePositionRange.start ? rowIndex + 1 : rowIndex;
                Object updatedKey = this.keyHandler.getKeyWithRowUpdate(entry.getKey(), modRow);
                ((UpdateDataChange)entry.getValue()).updateKey(updatedKey);
                modifiedRows.put(updatedKey, (UpdateDataChange)entry.getValue());
                if (!this.updateOnVerticalChanges) continue;
                List<DataChange> list = this.layer.dataChanges;
                synchronized (list) {
                    for (DataChange change : this.layer.dataChanges) {
                        if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || !change.getKey().equals(oldKey)) continue;
                        Object uk = this.keyHandler.getKeyWithRowUpdate(oldKey, modRow);
                        change.updateKey(uk);
                    }
                }
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleColumnDelete(Collection<StructuralDiff> columnDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(columnDiffs);
        Collections.sort(diffs, (o1, o2) -> o1.getBeforePositionRange().start - o2.getBeforePositionRange().start);
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff columnDiff : diffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                }
                ++i;
            }
        }
        if (!toRemove.isEmpty()) {
            HashMap modifiedColumns = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int columnIndex = this.keyHandler.getColumnIndex(entry.getKey());
                if (!toRemove.contains(columnIndex)) {
                    int deletedBefore = 0;
                    for (Integer removed : toRemove) {
                        if (removed >= columnIndex) continue;
                        ++deletedBefore;
                    }
                    int modColumn = columnIndex - deletedBefore;
                    if (modColumn < 0) continue;
                    Object oldKey = entry.getKey();
                    Object updatedKey = this.keyHandler.getKeyWithColumnUpdate(oldKey, modColumn);
                    ((UpdateDataChange)entry.getValue()).updateKey(updatedKey);
                    modifiedColumns.put(updatedKey, (UpdateDataChange)entry.getValue());
                    if (!this.updateOnVerticalChanges) continue;
                    List<DataChange> list = this.layer.dataChanges;
                    synchronized (list) {
                        for (DataChange change : this.layer.dataChanges) {
                            if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || !change.getKey().equals(oldKey)) continue;
                            Object uk = this.keyHandler.getKeyWithColumnUpdate(oldKey, modColumn);
                            change.updateKey(uk);
                        }
                        continue;
                    }
                }
                if (!this.updateOnHorizontalChanges) continue;
                Iterator<DataChange> it = this.layer.dataChanges.iterator();
                while (it.hasNext()) {
                    DataChange change = it.next();
                    if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || this.keyHandler.getColumnIndex(change.getKey()) != this.keyHandler.getColumnIndex(((UpdateDataChange)entry.getValue()).getKey())) continue;
                    it.remove();
                }
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleColumnInsert(Collection<StructuralDiff> columnDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(columnDiffs);
        Collections.sort(diffs, (o1, o2) -> o2.getBeforePositionRange().start - o1.getBeforePositionRange().start);
        for (StructuralDiff columnDiff : diffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            HashMap modifiedColumns = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int columnIndex = this.keyHandler.getColumnIndex(entry.getKey());
                Object oldKey = entry.getKey();
                int modColumn = -1;
                modColumn = columnIndex >= beforePositionRange.start ? columnIndex + 1 : columnIndex;
                Object updatedKey = this.keyHandler.getKeyWithColumnUpdate(entry.getKey(), modColumn);
                ((UpdateDataChange)entry.getValue()).updateKey(updatedKey);
                modifiedColumns.put(updatedKey, (UpdateDataChange)entry.getValue());
                if (!this.updateOnHorizontalChanges) continue;
                List<DataChange> list = this.layer.dataChanges;
                synchronized (list) {
                    for (DataChange change : this.layer.dataChanges) {
                        if (!change.getClass().equals(((UpdateDataChange)entry.getValue()).getClass()) || !change.getKey().equals(oldKey)) continue;
                        Object uk = this.keyHandler.getKeyWithColumnUpdate(oldKey, modColumn);
                        change.updateKey(uk);
                    }
                }
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedColumns);
        }
    }

    @Override
    public void clearDataChanges() {
        super.clearDataChanges();
        this.changedColumns.clear();
        this.changedRows.clear();
    }

    protected void removeChangesForDeletedColumnObjects() {
        Iterator it = this.dataChanges.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            int columnIndex = this.keyHandler.getColumnIndex(key);
            if (columnIndex >= 0) continue;
            if (this.updateOnHorizontalChanges) {
                UpdateDataChange localChange = (UpdateDataChange)this.dataChanges.get(key);
                Iterator<DataChange> iterator = this.layer.dataChanges.iterator();
                while (iterator.hasNext()) {
                    DataChange change = iterator.next();
                    if (!change.getClass().equals(localChange.getClass()) || this.keyHandler.getColumnIndex(change.getKey()) != this.keyHandler.getColumnIndex(localChange.getKey())) continue;
                    iterator.remove();
                }
            }
            it.remove();
        }
    }

    protected void removeChangesForDeletedRowObjects() {
        Iterator it = this.dataChanges.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            int rowIndex = this.keyHandler.getRowIndex(key);
            if (rowIndex >= 0) continue;
            if (this.updateOnVerticalChanges) {
                UpdateDataChange localChange = (UpdateDataChange)this.dataChanges.get(key);
                Iterator<DataChange> iterator = this.layer.dataChanges.iterator();
                while (iterator.hasNext()) {
                    DataChange change = iterator.next();
                    if (!change.getClass().equals(localChange.getClass()) || this.keyHandler.getRowIndex(change.getKey()) != this.keyHandler.getRowIndex(localChange.getKey())) continue;
                    iterator.remove();
                }
            }
            it.remove();
        }
    }

    protected void rebuildPositionCollections() {
        this.changedColumns.clear();
        this.changedRows.clear();
        for (Object key : this.dataChanges.keySet()) {
            int columnIndex = this.keyHandler.getColumnIndex(key);
            int rowIndex = this.keyHandler.getRowIndex(key);
            if (columnIndex < 0 || rowIndex < 0) continue;
            this.changedColumns.add(columnIndex);
            this.changedRows.add(rowIndex);
        }
    }

    @Override
    public boolean isColumnDirty(int columnPosition) {
        return this.changedColumns.contains(columnPosition);
    }

    @Override
    public boolean isRowDirty(int rowPosition) {
        return this.changedRows.contains(rowPosition);
    }

    @Override
    public boolean isCellDirty(int columnPosition, int rowPosition) {
        Object key = this.keyHandler.getKey(columnPosition, rowPosition);
        if (key != null) {
            return this.dataChanges.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return !this.dataChanges.isEmpty();
    }

    public void setUpdateOnHorizontalChanges(boolean update) {
        this.updateOnHorizontalChanges = update;
    }

    public void setUpdateOnVerticalChanges(boolean update) {
        this.updateOnVerticalChanges = update;
    }
}

