/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractShortSet;

public abstract class AbstractImmutableShortSet
extends AbstractShortSet
implements ImmutableShortSet {
    public ImmutableShortSet newWith(short element) {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableShortSet newWithout(short element) {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public ShortSet freeze() {
        return this;
    }

    public ImmutableShortSet toImmutable() {
        return this;
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                ShortIterator iterator = this.shortIterator();
                while (iterator.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

