/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.bag;

import java.io.Serializable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedMultimap;

public class SynchronizedBagMultimap<K, V>
extends AbstractSynchronizedMultimap<K, V>
implements MutableBagMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SynchronizedBagMultimap(MutableBagMultimap<K, V> multimap) {
        super(multimap);
    }

    public SynchronizedBagMultimap(MutableBagMultimap<K, V> multimap, Object newLock) {
        super(multimap, newLock);
    }

    public static <K, V> SynchronizedBagMultimap<K, V> of(MutableBagMultimap<K, V> multimap) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBagMultimap for null");
        }
        return new SynchronizedBagMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedBagMultimap<K, V> of(MutableBagMultimap<K, V> multimap, Object lock) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBagMultimap for null");
        }
        return new SynchronizedBagMultimap<K, V>(multimap, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyMutableBag(Procedure2<? super K, ? super MutableBag<V>> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachKeyMutableBag(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> withKeyMultiValues(K key, V ... values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().withKeyMultiValues(key, (Object[])values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> replaceValues(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().replaceValues(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> removeAll(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> get(K key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> getIfAbsentPutAll(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getIfAbsentPutAll(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> toMutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBagMultimap<K, V> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOccurrences(K key, V value, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().putOccurrences(key, value, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<V, K> flip() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeysValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeyMultiValues(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectValues(function);
        }
    }

    public MutableBagMultimap<K, V> asSynchronized() {
        return this;
    }

    @Override
    protected MutableBagMultimap<K, V> getDelegate() {
        return (MutableBagMultimap)super.getDelegate();
    }
}

