/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableLongLongMap;
import org.eclipse.collections.api.map.primitive.LongLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableLongLongSingletonMap
implements ImmutableLongLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final long key1;
    private final long value1;

    ImmutableLongLongSingletonMap(long key1, long value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public long get(long key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(long key, long ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public long getOrThrow(long key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        return this.key1 == key;
    }

    public boolean containsValue(long value) {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(LongProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(LongLongProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public boolean allSatisfyKeyValue(LongLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    public LazyLongIterable keysView() {
        return LongLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<LongLongPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableLongLongMap flipUniqueValues() {
        return LongLongMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableLongLongMap select(LongLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? LongLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new LongLongHashMap().toImmutable();
    }

    public ImmutableLongLongMap reject(LongLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new LongLongHashMap().toImmutable() : LongLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new LongIterable[]{LongBags.immutable.with(this.value1)});
    }

    public ImmutableLongLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)LongLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    public void each(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public long min() {
        return this.value1;
    }

    public long max() {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue) {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public long[] toSortedArray() {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongBag select(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongHashBag.newBagWith(this.value1).toImmutable() : LongBags.immutable.empty();
    }

    public ImmutableLongBag reject(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongBags.immutable.empty() : LongHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public long[] toArray() {
        return new long[]{this.value1};
    }

    public long[] toArray(long[] target) {
        if (target.length < 1) {
            target = new long[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(long value) {
        return this.value1 == value;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableLongList toList() {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableLongLongMap newWithKeyValue(long key, long value) {
        return LongLongMaps.immutable.withAll((LongLongMap)LongLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableLongLongMap newWithoutKey(long key) {
        return this.key1 == key ? LongLongMaps.immutable.with() : this;
    }

    public ImmutableLongLongMap newWithoutAllKeys(LongIterable keys) {
        return keys.contains(this.key1) ? LongLongMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(LongHashSet.newSetWith(this.key1));
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of((MutableLongCollection)LongArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongLongMap)) {
            return false;
        }
        LongLongMap map = (LongLongMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (int)(this.key1 ^ this.key1 >>> 32) ^ (int)(this.value1 ^ this.value1 >>> 32);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

