/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.poi;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.extension.poi.PoiExcelExporter;
import org.eclipse.swt.graphics.Color;

public class HSSFExcelExporter
extends PoiExcelExporter {
    private List<Color> colorIndex = new ArrayList<Color>();

    public HSSFExcelExporter() {
        super((IOutputStreamProvider)new FileOutputStreamProvider("table_export.xls", new String[]{"Excel Workbook (*.xls)"}, new String[]{"*.xls"}));
    }

    public HSSFExcelExporter(IOutputStreamProvider outputStreamProvider) {
        super(outputStreamProvider);
    }

    @Override
    protected Workbook createWorkbook() {
        this.colorIndex = new ArrayList<Color>();
        return new HSSFWorkbook();
    }

    @Override
    protected void setFillForegroundColor(CellStyle xlCellStyle, Color swtColor) {
        xlCellStyle.setFillForegroundColor(this.getColorIndex(swtColor));
    }

    @Override
    protected void setFontColor(Font xlFont, Color swtColor) {
        xlFont.setColor(this.getColorIndex(swtColor));
    }

    private short getColorIndex(Color swtColor) {
        if (!this.colorIndex.contains(swtColor)) {
            this.colorIndex.add(swtColor);
            HSSFPalette palette = ((HSSFWorkbook)this.xlWorkbook).getCustomPalette();
            palette.setColorAtIndex((short)(55 - this.colorIndex.indexOf(swtColor)), (byte)swtColor.getRed(), (byte)swtColor.getGreen(), (byte)swtColor.getBlue());
        }
        return (short)(55 - this.colorIndex.indexOf(swtColor));
    }
}

