// Copyright 2025 Ben Manes. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.github.benmanes.caffeine.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

/**
 * <em>WARNING: GENERATED CODE</em>
 *
 * <p>A cache that provides the following features:
 *
 * <ul>
 *   <li>RefreshWrite
 *   <li>StrongKeys (inherited)
 *   <li>InfirmValues (inherited)
 *   <li>ExpireWrite (inherited)
 *   <li>MaximumSize (inherited)
 *   <li>Listening (inherited)
 *   <li>Stats (inherited)
 * </ul>
 *
 * @author ben.manes@gmail.com (Ben Manes)
 */
final class SILSMSWR<K, V> extends SILSMSW<K, V> {
  static final LocalCacheFactory FACTORY = SILSMSWR::new;

  private static final VarHandle REFRESH_AFTER_WRITE_NANOS;

  static {
    MethodHandles.Lookup lookup = MethodHandles.lookup();
    try {
      REFRESH_AFTER_WRITE_NANOS =
          lookup.findVarHandle(
              SILSMSWR.class, LocalCacheFactory.REFRESH_AFTER_WRITE_NANOS, long.class);
    } catch (ReflectiveOperationException e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  volatile long refreshAfterWriteNanos;

  SILSMSWR(Caffeine<K, V> builder, AsyncCacheLoader<? super K, V> cacheLoader, boolean async) {
    super(builder, cacheLoader, async);
    setRefreshAfterWriteNanos(builder.getRefreshAfterWriteNanos());
  }

  protected boolean refreshAfterWrite() {
    return true;
  }

  protected long refreshAfterWriteNanos() {
    return (long) REFRESH_AFTER_WRITE_NANOS.getAcquire(this);
  }

  protected void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
    REFRESH_AFTER_WRITE_NANOS.setRelease(this, refreshAfterWriteNanos);
  }
}
