// Copyright 2025 Ben Manes. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.github.benmanes.caffeine.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

/**
 * <em>WARNING: GENERATED CODE</em>
 *
 * <p>A cache that provides the following features:
 *
 * <ul>
 *   <li>ExpireAccess
 *   <li>StrongKeys (inherited)
 *   <li>InfirmValues (inherited)
 *   <li>MaximumSize (inherited)
 *   <li>Listening (inherited)
 * </ul>
 *
 * @author ben.manes@gmail.com (Ben Manes)
 */
class SILMSA<K, V> extends SILMS<K, V> {
  static final LocalCacheFactory FACTORY = SILMSA::new;

  protected static final VarHandle EXPIRES_AFTER_ACCESS_NANOS;

  static {
    MethodHandles.Lookup lookup = MethodHandles.lookup();
    try {
      EXPIRES_AFTER_ACCESS_NANOS =
          lookup.findVarHandle(
              SILMSA.class, LocalCacheFactory.EXPIRES_AFTER_ACCESS_NANOS, long.class);
    } catch (ReflectiveOperationException e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  final Ticker ticker;

  final Expiry<K, V> expiry;

  final TimerWheel<K, V> timerWheel;

  volatile long expiresAfterAccessNanos;

  final Pacer pacer;

  SILMSA(Caffeine<K, V> builder, AsyncCacheLoader<? super K, V> cacheLoader, boolean async) {
    super(builder, cacheLoader, async);
    this.ticker = builder.getTicker();
    this.expiry = builder.getExpiry(isAsync);
    this.timerWheel = builder.expiresVariable() ? new TimerWheel<K, V>() : null;
    setExpiresAfterAccessNanos(builder.getExpiresAfterAccessNanos());
    this.pacer =
        (builder.getScheduler() == Scheduler.disabledScheduler())
            ? null
            : new Pacer(builder.getScheduler());
  }

  public final Ticker expirationTicker() {
    return ticker;
  }

  protected final boolean expiresVariable() {
    return (timerWheel != null);
  }

  public final Expiry<K, V> expiry() {
    return expiry;
  }

  protected final TimerWheel<K, V> timerWheel() {
    return timerWheel;
  }

  protected final long expiresAfterAccessNanos() {
    return (long) EXPIRES_AFTER_ACCESS_NANOS.getAcquire(this);
  }

  protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
    EXPIRES_AFTER_ACCESS_NANOS.setRelease(this, expiresAfterAccessNanos);
  }

  protected final boolean expiresAfterAccess() {
    return (timerWheel == null);
  }

  public final Pacer pacer() {
    return pacer;
  }
}
