/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TaskAttributeDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Test;

public class TaskDataDiffTest
extends TestCase {
    private RepositoryModel model;
    private TaskRepository repository;
    private TaskAttributeMapper mapper;
    private TaskData newData;
    private TaskData oldData;

    protected void setUp() throws Exception {
        TaskTask task = new TaskTask("kind", "url", "1");
        this.repository = new TaskRepository(task.getConnectorKind(), task.getRepositoryUrl());
        this.mapper = new TaskAttributeMapper(this.repository);
        TaskRepositoryManager repositoryManager = new TaskRepositoryManager();
        repositoryManager.addRepository(this.repository);
        TaskList taskList = new TaskList();
        taskList.addTask((ITask)task);
        this.model = new RepositoryModel(taskList, (IRepositoryManager)repositoryManager);
        this.newData = new TaskData(this.mapper, this.repository.getConnectorKind(), this.repository.getUrl(), "1");
        this.oldData = new TaskData(this.mapper, this.repository.getConnectorKind(), this.repository.getUrl(), "1");
    }

    @Test
    public void testGetChangedAttributes() {
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertEquals(Collections.emptySet(), (Object)diff.getChangedAttributes());
    }

    @Test
    public void testGetChangedAttributesMultiple() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        TaskAttribute attributeSummary = this.newData.getRoot().createAttribute("task.common.summary");
        attributeSummary.setValue("1");
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertEquals(Collections.singleton(new TaskAttributeDiff(null, attributeSummary)), (Object)diff.getChangedAttributes());
    }

    @Test
    public void testGetChangedAttributesMultipleKind() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        attributeCustom.getMetaData().setKind("kind");
        TaskAttribute attributeSummary = this.newData.getRoot().createAttribute("task.common.summary");
        attributeSummary.setValue("1");
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        List<TaskAttributeDiff> expected = Arrays.asList(new TaskAttributeDiff(null, attributeSummary), new TaskAttributeDiff(null, attributeCustom));
        TaskDataDiffTest.assertEquals(new LinkedHashSet<TaskAttributeDiff>(expected), (Object)diff.getChangedAttributes());
    }

    @Test
    public void testGetChangedAttributesSummary() {
        TaskAttribute attribute = this.newData.getRoot().createAttribute("task.common.summary");
        attribute.setValue("text");
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertEquals(Collections.singleton(new TaskAttributeDiff(null, attribute)), (Object)diff.getChangedAttributes());
    }

    @Test
    public void testGetChangedAttributesSummaryEmptyValue() {
        this.newData.getRoot().createAttribute("task.common.summary");
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertEquals(Collections.emptySet(), (Object)diff.getChangedAttributes());
    }

    @Test
    public void testHasChanges() {
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertFalse((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangesAttribute() {
        this.newData.getRoot().createAttribute("task.common.summary").setValue("text");
        TaskDataDiff diff = new TaskDataDiff(this.model, this.newData, this.oldData);
        TaskDataDiffTest.assertTrue((boolean)diff.hasChanged());
    }
}

