/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.Workbench;

public class TaskWorkingSetTest
extends TestCase {
    private IProject project;
    private IWorkspaceRoot root;
    private IWorkingSet workingSet;
    private IWorkingSetManager workingSetManager;

    protected void setUp() throws Exception {
        this.workingSetManager = Workbench.getInstance().getWorkingSetManager();
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        TestFixture.resetTaskList();
    }

    protected void tearDown() throws Exception {
        if (this.workingSet != null) {
            this.workingSetManager.removeWorkingSet(this.workingSet);
        }
        if (this.project != null) {
            ResourceTestUtil.deleteProject((IProject)this.project);
        }
    }

    public void testDeleteQuery() {
        MockRepositoryQuery query = new MockRepositoryQuery("description");
        TaskList taskList = TasksUiPlugin.getTaskList();
        taskList.addQuery((RepositoryQuery)query);
        this.workingSet = this.createWorkingSet((IAdaptable)query);
        TaskWorkingSetTest.assertTrue((boolean)Arrays.asList(this.workingSet.getElements()).contains((Object)query));
        TasksUiPlugin.getTaskList().deleteQuery((RepositoryQuery)query);
        TaskWorkingSetTest.assertFalse((boolean)Arrays.asList(this.workingSet.getElements()).contains((Object)query));
    }

    public void testRenameQuery() {
        MockRepositoryQuery query = new MockRepositoryQuery("description");
        TaskList taskList = TasksUiPlugin.getTaskList();
        taskList.addQuery((RepositoryQuery)query);
        this.workingSet = this.createWorkingSet((IAdaptable)query);
        TaskWorkingSetTest.assertTrue((this.workingSet.getElements().length == 1 ? 1 : 0) != 0);
        IAdaptable[] elements = this.workingSet.getElements();
        TaskWorkingSetTest.assertTrue((elements.length == 1 ? 1 : 0) != 0);
        TaskWorkingSetTest.assertTrue((boolean)(elements[0] instanceof MockRepositoryQuery));
        TaskWorkingSetTest.assertTrue((boolean)((MockRepositoryQuery)elements[0]).getHandleIdentifier().equals("description"));
        TaskWorkingSetTest.assertTrue((boolean)Arrays.asList(this.workingSet.getElements()).contains((Object)query));
        query.setHandleIdentifier("Test");
        TaskWorkingSetTest.assertTrue((this.workingSet.getElements().length == 1 ? 1 : 0) != 0);
        elements = this.workingSet.getElements();
        TaskWorkingSetTest.assertTrue((elements.length == 1 ? 1 : 0) != 0);
        TaskWorkingSetTest.assertTrue((boolean)(elements[0] instanceof MockRepositoryQuery));
        TaskWorkingSetTest.assertTrue((boolean)((MockRepositoryQuery)elements[0]).getHandleIdentifier().equals("Test"));
        TaskWorkingSetTest.assertTrue((boolean)Arrays.asList(this.workingSet.getElements()).contains((Object)query));
    }

    public void testRenameProject() throws Exception {
        this.createProject("Test Rename");
        this.workingSet = this.createWorkingSet((IAdaptable)this.project);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ProjectDescription description = new ProjectDescription();
                description.setName("New Name");
                TaskWorkingSetTest.this.project.move((IProjectDescription)description, true, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        op.run((IProgressMonitor)new NullProgressMonitor());
        IProject oldProject = this.root.getProject("Test Rename");
        IProject newProject = this.root.getProject("New Name");
        TaskWorkingSetTest.assertFalse((boolean)Arrays.asList(this.workingSet.getElements()).contains(oldProject));
        TaskWorkingSetTest.assertTrue((boolean)Arrays.asList(this.workingSet.getElements()).contains(newProject));
    }

    private void createProject(String name) throws CoreException {
        this.project = this.root.getProject(name);
        this.project.create(null);
        this.project.open(null);
    }

    private IWorkingSet createWorkingSet(IAdaptable element) {
        IWorkingSet workingSet = this.workingSetManager.createWorkingSet("Task Working Set", new IAdaptable[]{element});
        workingSet.setId(TaskWorkingSetUpdater.ID_TASK_WORKING_SET);
        TaskWorkingSetTest.assertTrue((boolean)Arrays.asList(workingSet.getElements()).contains(element));
        this.workingSetManager.addWorkingSet(workingSet);
        return workingSet;
    }
}

