/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUrl() {
        LocalTask task = new LocalTask("handle", "label");
        task.setUrl("http://eclipse.org/mylyn/doc");
        TaskTest.assertTrue((boolean)TasksUiInternal.isValidUrl((String)task.getUrl()));
        task.setUrl("http://");
        TaskTest.assertFalse((boolean)TasksUiInternal.isValidUrl((String)task.getUrl()));
        task.setUrl("https://");
        TaskTest.assertFalse((boolean)TasksUiInternal.isValidUrl((String)task.getUrl()));
        task.setUrl("");
        TaskTest.assertFalse((boolean)TasksUiInternal.isValidUrl((String)task.getUrl()));
        task.setUrl(null);
        TaskTest.assertFalse((boolean)TasksUiInternal.isValidUrl((String)task.getUrl()));
    }

    public void testPriorityNeverNull() {
        LocalTask task = new LocalTask("handle", "label");
        TaskTest.assertNotNull((Object)task.getPriority());
        ITask.PriorityLevel def = ITask.PriorityLevel.getDefault();
        TaskTest.assertNotNull((Object)def);
        TaskTest.assertEquals((Object)def, (Object)ITask.PriorityLevel.fromDescription((String)"garbage"));
        TaskTest.assertEquals((Object)def, (Object)ITask.PriorityLevel.fromString((String)"garbage"));
    }

    public void testPriorityLevelFromLevel() {
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)ITask.PriorityLevel.fromLevel((int)Integer.MIN_VALUE));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)ITask.PriorityLevel.fromLevel((int)-1));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)ITask.PriorityLevel.fromLevel((int)0));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)ITask.PriorityLevel.fromLevel((int)1));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)ITask.PriorityLevel.fromLevel((int)2));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)ITask.PriorityLevel.fromLevel((int)3));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)ITask.PriorityLevel.fromLevel((int)4));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)ITask.PriorityLevel.fromLevel((int)5));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)ITask.PriorityLevel.fromLevel((int)6));
        TaskTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)ITask.PriorityLevel.fromLevel((int)Integer.MAX_VALUE));
    }
}

