/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;

public class BackgroundSaveTest
extends TestCase {
    public void testBackgroundSave() throws InterruptedException, IOException {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("linux")) {
            System.out.println("> BackgroundSaveTest.testBackgroundSave() not run on Linux due to IO concurrency");
        } else {
            LocalTask task = new LocalTask("1", "summary");
            String filePath = TasksUiPlugin.getDefault().getDataDirectory() + File.separator + "tasks.xml.zip";
            File file = new File(filePath);
            long previouslyModified = file.lastModified();
            TasksUiPlugin.getTaskList().addTask((ITask)task);
            TasksUiPlugin.getExternalizationManager().requestSave();
            Thread.sleep(5000L);
            BackgroundSaveTest.assertTrue((file.lastModified() > previouslyModified ? 1 : 0) != 0);
            TasksUiPlugin.getTaskList().deleteTask((ITask)task);
        }
    }
}

