/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.shared;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.shared.BidiUtils;

public class BidiFormatter {
    private boolean alwaysSpan;
    private HasDirection.Direction contextDir;

    public static BidiFormatter getInstance(boolean rtlContext) {
        return BidiFormatter.getInstance(rtlContext, false);
    }

    public static BidiFormatter getInstance(boolean rtlContext, boolean alwaysSpan) {
        return new BidiFormatter(rtlContext ? HasDirection.Direction.RTL : HasDirection.Direction.LTR, alwaysSpan);
    }

    public static BidiFormatter getInstance(HasDirection.Direction contextDir) {
        return BidiFormatter.getInstance(contextDir, false);
    }

    public static BidiFormatter getInstance(HasDirection.Direction contextDir, boolean alwaysSpan) {
        return new BidiFormatter(contextDir, alwaysSpan);
    }

    public static BidiFormatter getInstanceForCurrentLocale() {
        return BidiFormatter.getInstanceForCurrentLocale(false);
    }

    public static BidiFormatter getInstanceForCurrentLocale(boolean alwaysSpan) {
        return BidiFormatter.getInstance(LocaleInfo.getCurrentLocale().isRTL(), alwaysSpan);
    }

    private BidiFormatter(HasDirection.Direction contextDir, boolean alwaysSpan) {
        this.contextDir = contextDir;
        this.alwaysSpan = alwaysSpan;
    }

    public String dirAttr(String str) {
        return this.dirAttr(str, false);
    }

    public String dirAttr(String str, boolean isHtml) {
        return this.knownDirAttr(BidiUtils.get().estimateDirection(str, isHtml));
    }

    public String endEdge() {
        return this.contextDir == HasDirection.Direction.RTL ? "left" : "right";
    }

    public HasDirection.Direction estimateDirection(String str) {
        return BidiUtils.get().estimateDirection(str);
    }

    public HasDirection.Direction estimateDirection(String str, boolean isHtml) {
        return BidiUtils.get().estimateDirection(str, isHtml);
    }

    public boolean getAlwaysSpan() {
        return this.alwaysSpan;
    }

    public HasDirection.Direction getContextDir() {
        return this.contextDir;
    }

    public boolean isRtlContext() {
        return this.contextDir == HasDirection.Direction.RTL;
    }

    public String knownDirAttr(HasDirection.Direction dir) {
        if (dir != this.contextDir) {
            return dir == HasDirection.Direction.LTR ? "dir=ltr" : (dir == HasDirection.Direction.RTL ? "dir=rtl" : "");
        }
        return "";
    }

    public String mark() {
        return this.contextDir == HasDirection.Direction.LTR ? Format.LRM_STRING : (this.contextDir == HasDirection.Direction.RTL ? Format.RLM_STRING : "");
    }

    public String markAfter(String str) {
        return this.markAfter(str, false);
    }

    public String markAfter(String str, boolean isHtml) {
        str = BidiUtils.get().stripHtmlIfNeeded(str, isHtml);
        return this.dirResetIfNeeded(str, BidiUtils.get().estimateDirection(str), false, true);
    }

    public String spanWrap(String str) {
        return this.spanWrap(str, false, true);
    }

    public String spanWrap(String str, boolean isHtml) {
        return this.spanWrap(str, isHtml, true);
    }

    public String spanWrap(String str, boolean isHtml, boolean dirReset) {
        HasDirection.Direction dir = BidiUtils.get().estimateDirection(str, isHtml);
        return this.spanWrapWithKnownDir(dir, str, isHtml, dirReset);
    }

    public String spanWrapWithKnownDir(HasDirection.Direction dir, String str) {
        return this.spanWrapWithKnownDir(dir, str, false, true);
    }

    public String spanWrapWithKnownDir(HasDirection.Direction dir, String str, boolean isHtml) {
        return this.spanWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String spanWrapWithKnownDir(HasDirection.Direction dir, String str, boolean isHtml, boolean dirReset) {
        boolean dirCondition = dir != HasDirection.Direction.DEFAULT && dir != this.contextDir;
        String origStr = str;
        if (!isHtml) {
            str = this.htmlEscape(str);
        }
        StringBuilder result = new StringBuilder();
        if (this.alwaysSpan || dirCondition) {
            result.append("<span");
            if (dirCondition) {
                result.append(" ");
                result.append(dir == HasDirection.Direction.RTL ? "dir=rtl" : "dir=ltr");
            }
            result.append(">" + str + "</span>");
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(origStr, dir, isHtml, dirReset));
        return result.toString();
    }

    public String startEdge() {
        return this.contextDir == HasDirection.Direction.RTL ? "right" : "left";
    }

    public String unicodeWrap(String str) {
        return this.unicodeWrap(str, false, true);
    }

    public String unicodeWrap(String str, boolean isHtml) {
        return this.unicodeWrap(str, isHtml, true);
    }

    public String unicodeWrap(String str, boolean isHtml, boolean dirReset) {
        HasDirection.Direction dir = BidiUtils.get().estimateDirection(str, isHtml);
        return this.unicodeWrapWithKnownDir(dir, str, isHtml, dirReset);
    }

    public String unicodeWrapWithKnownDir(HasDirection.Direction dir, String str) {
        return this.unicodeWrapWithKnownDir(dir, str, false, true);
    }

    public String unicodeWrapWithKnownDir(HasDirection.Direction dir, String str, boolean isHtml) {
        return this.unicodeWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String unicodeWrapWithKnownDir(HasDirection.Direction dir, String str, boolean isHtml, boolean dirReset) {
        StringBuilder result = new StringBuilder();
        if (dir != HasDirection.Direction.DEFAULT && dir != this.contextDir) {
            result.append(dir == HasDirection.Direction.RTL ? (char)'\u202b' : '\u202a');
            result.append(str);
            result.append('\u202c');
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(str, dir, isHtml, dirReset));
        return result.toString();
    }

    private String dirResetIfNeeded(String str, HasDirection.Direction dir, boolean isHtml, boolean dirReset) {
        if (dirReset && (this.contextDir == HasDirection.Direction.LTR && (dir == HasDirection.Direction.RTL || BidiUtils.get().endsWithRtl(str, isHtml)) || this.contextDir == HasDirection.Direction.RTL && (dir == HasDirection.Direction.LTR || BidiUtils.get().endsWithLtr(str, isHtml)))) {
            return this.contextDir == HasDirection.Direction.LTR ? Format.LRM_STRING : Format.RLM_STRING;
        }
        return "";
    }

    private String htmlEscape(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>");
    }

    static final class Format {
        public static final String LEFT = "left";
        public static final char LRE = '\u202a';
        public static final char LRM = '\u200e';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final char PDF = '\u202c';
        public static final String RIGHT = "right";
        public static final char RLE = '\u202b';
        public static final char RLM = '\u200f';
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }
}

