/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T> {
    private Object curKey;
    private T curSelection;
    private boolean newSelected;
    private T newSelectedObject = null;
    private boolean newSelectedPending;

    public SingleSelectionModel() {
        super(null);
    }

    public SingleSelectionModel(ProvidesKey<T> keyProvider) {
        super(keyProvider);
    }

    public T getSelectedObject() {
        this.resolveChanges();
        return this.curSelection;
    }

    @Override
    public boolean isSelected(T object) {
        this.resolveChanges();
        if (this.curSelection == null || this.curKey == null || object == null) {
            return false;
        }
        return this.curKey.equals(this.getKey(object));
    }

    @Override
    public void setSelected(T object, boolean selected) {
        this.newSelectedObject = object;
        this.newSelected = selected;
        this.newSelectedPending = true;
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    private void resolveChanges() {
        Object key;
        if (!this.newSelectedPending) {
            return;
        }
        Object object = key = this.newSelectedObject == null ? null : this.getKey(this.newSelectedObject);
        boolean sameKey = this.curKey == null ? key == null : this.curKey.equals(key);
        boolean changed = false;
        if (this.newSelected) {
            changed = !sameKey;
            this.curSelection = this.newSelectedObject;
            this.curKey = key;
        } else if (sameKey) {
            changed = true;
            this.curSelection = null;
            this.curKey = null;
        }
        this.newSelectedObject = null;
        this.newSelectedPending = false;
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }
}

