/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosureHandler;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.FiresDisclosureEvents;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetIterators;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DisclosurePanel
extends Composite
implements FiresDisclosureEvents,
HasWidgets,
HasAnimation,
HasOpenHandlers<DisclosurePanel>,
HasCloseHandlers<DisclosurePanel> {
    private static final DefaultImages DEFAULT_IMAGES = (DefaultImages)GWT.create(DefaultImages.class);
    private static final int ANIMATION_DURATION = 350;
    private static final String STYLENAME_DEFAULT = "gwt-DisclosurePanel";
    private static final String STYLENAME_SUFFIX_OPEN = "open";
    private static final String STYLENAME_SUFFIX_CLOSED = "closed";
    private static final String STYLENAME_HEADER = "header";
    private static final String STYLENAME_CONTENT = "content";
    private static ContentAnimation contentAnimation;
    private final VerticalPanel mainPanel = new VerticalPanel();
    private final SimplePanel contentWrapper = new SimplePanel();
    private final ClickableHeader header = new ClickableHeader();
    private boolean isAnimationEnabled = false;
    private boolean isOpen = false;

    public DisclosurePanel() {
        this.initWidget(this.mainPanel);
        this.mainPanel.add(this.header);
        this.mainPanel.add(this.contentWrapper);
        DOM.setStyleAttribute(this.contentWrapper.getElement(), "padding", "0px");
        DOM.setStyleAttribute(this.contentWrapper.getElement(), "overflow", "hidden");
        this.setStyleName(STYLENAME_DEFAULT);
        this.setContentDisplay(false);
    }

    @Deprecated
    public DisclosurePanel(DisclosurePanelImages images, String headerText, boolean isOpen) {
        this();
        this.setOpen(isOpen);
        this.setHeader(new DefaultHeader(images, headerText));
    }

    public DisclosurePanel(ImageResource openImage, ImageResource closedImage, String headerText) {
        this();
        this.setHeader(new DefaultHeader(openImage, closedImage, headerText));
    }

    public DisclosurePanel(String headerText) {
        this(DEFAULT_IMAGES.disclosurePanelOpen(), DEFAULT_IMAGES.disclosurePanelClosed(), headerText);
    }

    @Deprecated
    public DisclosurePanel(String headerText, boolean isOpen) {
        this(DEFAULT_IMAGES.disclosurePanelOpen(), DEFAULT_IMAGES.disclosurePanelClosed(), headerText);
        this.setOpen(isOpen);
    }

    public DisclosurePanel(Widget header) {
        this();
        this.setHeader(header);
    }

    @Deprecated
    public DisclosurePanel(Widget header, boolean isOpen) {
        this();
        this.setHeader(header);
        this.setOpen(isOpen);
    }

    @Override
    public void add(Widget w) {
        if (this.getContent() != null) {
            throw new IllegalStateException("A DisclosurePanel can only contain two Widgets.");
        }
        this.setContent(w);
    }

    @Override
    public HandlerRegistration addCloseHandler(CloseHandler<DisclosurePanel> handler) {
        return this.addHandler(handler, CloseEvent.getType());
    }

    @Override
    @Deprecated
    public void addEventHandler(DisclosureHandler handler) {
        ListenerWrapper.WrappedOldDisclosureHandler.add(this, handler);
    }

    @Override
    public HandlerRegistration addOpenHandler(OpenHandler<DisclosurePanel> handler) {
        return this.addHandler(handler, OpenEvent.getType());
    }

    @Override
    public void clear() {
        this.setContent(null);
    }

    public Widget getContent() {
        return this.contentWrapper.getWidget();
    }

    public Widget getHeader() {
        return this.header.getWidget();
    }

    public HasText getHeaderTextAccessor() {
        Widget widget = this.header.getWidget();
        return widget instanceof HasText ? (HasText)((Object)widget) : null;
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public Iterator<Widget> iterator() {
        return WidgetIterators.createWidgetIterator(this, new Widget[]{this.getContent()});
    }

    @Override
    public boolean remove(Widget w) {
        if (w == this.getContent()) {
            this.setContent(null);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void removeEventHandler(DisclosureHandler handler) {
        ListenerWrapper.WrappedOldDisclosureHandler.remove(this, handler);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setContent(Widget content) {
        Widget currentContent = this.getContent();
        if (currentContent != null) {
            this.contentWrapper.setWidget(null);
            currentContent.removeStyleName(STYLENAME_CONTENT);
        }
        if (content != null) {
            this.contentWrapper.setWidget(content);
            content.addStyleName(STYLENAME_CONTENT);
            this.setContentDisplay(false);
        }
    }

    public void setHeader(Widget headerWidget) {
        this.header.setWidget(headerWidget);
    }

    public void setOpen(boolean isOpen) {
        if (this.isOpen != isOpen) {
            this.isOpen = isOpen;
            this.setContentDisplay(true);
            this.fireEvent();
        }
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.header.ensureDebugId(baseID + "-header");
    }

    private void fireEvent() {
        if (this.isOpen) {
            OpenEvent.fire(this, this);
        } else {
            CloseEvent.fire(this, this);
        }
    }

    private void setContentDisplay(boolean animate) {
        if (this.isOpen) {
            this.removeStyleDependentName(STYLENAME_SUFFIX_CLOSED);
            this.addStyleDependentName(STYLENAME_SUFFIX_OPEN);
        } else {
            this.removeStyleDependentName(STYLENAME_SUFFIX_OPEN);
            this.addStyleDependentName(STYLENAME_SUFFIX_CLOSED);
        }
        if (this.getContent() != null) {
            if (contentAnimation == null) {
                contentAnimation = new ContentAnimation();
            }
            contentAnimation.setOpen(this, animate && this.isAnimationEnabled);
        }
    }

    private static interface Imager {
        public Image makeImage();

        public void updateImage(boolean var1, Image var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultHeader
    extends Widget
    implements HasText,
    OpenHandler<DisclosurePanel>,
    CloseHandler<DisclosurePanel> {
        private final Element labelTD;
        private final Image iconImage;
        private final Imager imager;

        private DefaultHeader(final DisclosurePanelImages images, String text) {
            this(new Imager(){

                public Image makeImage() {
                    return images.disclosurePanelClosed().createImage();
                }

                public void updateImage(boolean open, Image image) {
                    if (open) {
                        images.disclosurePanelOpen().applyTo(image);
                    } else {
                        images.disclosurePanelClosed().applyTo(image);
                    }
                }
            }, text);
        }

        private DefaultHeader(Imager imager, String text) {
            this.imager = imager;
            this.iconImage = imager.makeImage();
            Element root = DOM.createTable();
            Element tbody = DOM.createTBody();
            Element tr = DOM.createTR();
            Element imageTD = DOM.createTD();
            this.labelTD = DOM.createTD();
            this.setElement(root);
            DOM.appendChild(root, tbody);
            DOM.appendChild(tbody, tr);
            DOM.appendChild(tr, imageTD);
            DOM.appendChild(tr, this.labelTD);
            DOM.setElementProperty(imageTD, "align", "center");
            DOM.setElementProperty(imageTD, "valign", "middle");
            DOM.setStyleAttribute(imageTD, "width", this.iconImage.getWidth() + "px");
            DOM.appendChild(imageTD, this.iconImage.getElement());
            this.setText(text);
            DisclosurePanel.this.addOpenHandler(this);
            DisclosurePanel.this.addCloseHandler(this);
            this.setStyle();
        }

        private DefaultHeader(final ImageResource openImage, final ImageResource closedImage, String text) {
            this(new Imager(){

                public Image makeImage() {
                    return new Image(closedImage);
                }

                public void updateImage(boolean open, Image image) {
                    if (open) {
                        image.setResource(openImage);
                    } else {
                        image.setResource(closedImage);
                    }
                }
            }, text);
        }

        @Override
        public final String getText() {
            return DOM.getInnerText(this.labelTD);
        }

        @Override
        public final void onClose(CloseEvent<DisclosurePanel> event) {
            this.setStyle();
        }

        @Override
        public final void onOpen(OpenEvent<DisclosurePanel> event) {
            this.setStyle();
        }

        @Override
        public final void setText(String text) {
            DOM.setInnerText(this.labelTD, text);
        }

        private void setStyle() {
            this.imager.updateImage(DisclosurePanel.this.isOpen, this.iconImage);
        }
    }

    private static class ContentAnimation
    extends Animation {
        private boolean opening;
        private DisclosurePanel curPanel;

        private ContentAnimation() {
        }

        public void setOpen(DisclosurePanel panel, boolean animate) {
            this.cancel();
            if (animate) {
                this.curPanel = panel;
                this.opening = panel.isOpen;
                this.run(350);
            } else {
                panel.contentWrapper.setVisible(panel.isOpen);
                if (panel.isOpen) {
                    panel.getContent().setVisible(true);
                }
            }
        }

        protected void onComplete() {
            if (!this.opening) {
                this.curPanel.contentWrapper.setVisible(false);
            }
            DOM.setStyleAttribute(this.curPanel.contentWrapper.getElement(), "height", "auto");
            this.curPanel = null;
        }

        protected void onStart() {
            super.onStart();
            if (this.opening) {
                this.curPanel.contentWrapper.setVisible(true);
                this.curPanel.getContent().setVisible(true);
            }
        }

        protected void onUpdate(double progress) {
            int scrollHeight = DOM.getElementPropertyInt(this.curPanel.contentWrapper.getElement(), "scrollHeight");
            int height = (int)(progress * (double)scrollHeight);
            if (!this.opening) {
                height = scrollHeight - height;
            }
            height = Math.max(height, 1);
            DOM.setStyleAttribute(this.curPanel.contentWrapper.getElement(), "height", height + "px");
            DOM.setStyleAttribute(this.curPanel.contentWrapper.getElement(), "width", "auto");
        }
    }

    private final class ClickableHeader
    extends SimplePanel {
        private ClickableHeader() {
            super(DOM.createAnchor());
            Element elem = this.getElement();
            DOM.setElementProperty(elem, "href", "javascript:void(0);");
            DOM.setStyleAttribute(elem, "display", "block");
            this.sinkEvents(1);
            this.setStyleName(DisclosurePanel.STYLENAME_HEADER);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType(event)) {
                case 1: {
                    DOM.eventPreventDefault(event);
                    DisclosurePanel.this.setOpen(!DisclosurePanel.this.isOpen);
                }
            }
        }
    }

    static interface DefaultImages
    extends ClientBundle {
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource disclosurePanelClosed();

        public ImageResource disclosurePanelOpen();
    }
}

