/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;
import com.google.gwt.user.client.rpc.impl.RpcStatsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCallbackAdapter<T>
implements RequestCallback {
    private final AsyncCallback<T> callback;
    private final String methodName;
    private final RpcStatsContext statsContext;
    private final ResponseReader responseReader;
    private final SerializationStreamFactory streamFactory;

    public RequestCallbackAdapter(SerializationStreamFactory streamFactory, String methodName, RpcStatsContext statsContext, AsyncCallback<T> callback, ResponseReader responseReader) {
        assert (streamFactory != null);
        assert (callback != null);
        assert (responseReader != null);
        this.streamFactory = streamFactory;
        this.callback = callback;
        this.methodName = methodName;
        this.statsContext = statsContext;
        this.responseReader = responseReader;
    }

    @Override
    public void onError(Request request, Throwable exception) {
        this.callback.onFailure(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onResponseReceived(Request request, Response response) {
        Throwable returned;
        boolean toss;
        Object result = null;
        Throwable caught = null;
        try {
            boolean toss2;
            String encodedResponse = response.getText();
            int statusCode = response.getStatusCode();
            boolean bl = toss2 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.bytesStat(this.methodName, encodedResponse.length(), "responseReceived"));
            if (statusCode != 200) {
                caught = new StatusCodeException(statusCode, encodedResponse);
            } else if (encodedResponse == null) {
                caught = new InvocationException("No response payload");
            } else if (RemoteServiceProxy.isReturnValue(encodedResponse)) {
                result = this.responseReader.read(this.streamFactory.createStreamReader(encodedResponse));
            } else {
                caught = RemoteServiceProxy.isThrownException(encodedResponse) ? (Throwable)this.streamFactory.createStreamReader(encodedResponse).readObject() : new InvocationException(encodedResponse);
            }
            toss = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
        }
        catch (SerializationException e) {
            caught = new IncompatibleRemoteServiceException("The response could not be deserialized", e);
            toss = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
        }
        catch (Throwable e2) {
            caught = e2;
            toss = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
            {
                catch (Throwable throwable) {
                    boolean toss3 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
                    throw throwable;
                }
            }
        }
        try {
            if (caught == null) {
                this.callback.onSuccess((Throwable)result);
            } else {
                this.callback.onFailure(caught);
            }
            returned = caught == null ? result : caught;
        }
        catch (Throwable throwable) {
            Throwable returned2 = caught == null ? result : caught;
            boolean toss4 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, returned2, "end"));
            throw throwable;
        }
        boolean toss5 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, returned, "end"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseReader {
        BOOLEAN{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readBoolean();
            }
        }
        ,
        BYTE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readByte();
            }
        }
        ,
        CHAR{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Character.valueOf(streamReader.readChar());
            }
        }
        ,
        DOUBLE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readDouble();
            }
        }
        ,
        FLOAT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Float.valueOf(streamReader.readFloat());
            }
        }
        ,
        INT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readInt();
            }
        }
        ,
        LONG{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readLong();
            }
        }
        ,
        OBJECT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readObject();
            }
        }
        ,
        SHORT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readShort();
            }
        }
        ,
        STRING{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readString();
            }
        }
        ,
        VOID{

            public Object read(SerializationStreamReader streamReader) {
                return null;
            }
        };


        public abstract Object read(SerializationStreamReader var1) throws SerializationException;
    }
}

