/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.attributeparsers.BundleAttributeParser;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.model.OwnerClass;
import com.google.gwt.uibinder.rebind.model.OwnerField;
import com.google.gwt.uibinder.rebind.model.OwnerFieldClass;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BundleAttributeParsers {
    private static final String BUNDLE_URI_SCHEME = "urn:with:";
    private final TypeOracle oracle;
    private final MortalLogger logger;
    private final OwnerClass ownerClass;
    private final String templatePath;
    private final JClassType uiOwnerType;
    private final Map<String, BundleAttributeParser> parsers = new LinkedHashMap<String, BundleAttributeParser>();

    public BundleAttributeParsers(TypeOracle oracle, MortalLogger logger, OwnerClass ownerClass, String templatePath, JClassType uiOwnerType) {
        this.oracle = oracle;
        this.logger = logger;
        this.ownerClass = ownerClass;
        this.templatePath = templatePath;
        this.uiOwnerType = uiOwnerType;
    }

    public BundleAttributeParser get(OwnerFieldClass type) {
        return this.parsers.get(type.getRawType().getQualifiedSourceName());
    }

    public BundleAttributeParser get(XMLAttribute attribute) throws UnableToCompleteException {
        String attributePrefixUri = attribute.getNamespaceUri();
        if (attributePrefixUri == null || !attributePrefixUri.startsWith(BUNDLE_URI_SCHEME)) {
            return null;
        }
        String bundleClassName = attributePrefixUri.substring(BUNDLE_URI_SCHEME.length());
        BundleAttributeParser parser = this.parsers.get(bundleClassName);
        if (parser == null) {
            JClassType bundleClassType = this.getOracle().findType(bundleClassName);
            if (bundleClassType == null) {
                this.die(attribute.getElement(), "No such resource class: " + bundleClassName, new Object[0]);
            }
            parser = this.createBundleParser(bundleClassType, attribute);
            this.parsers.put(bundleClassName, parser);
        }
        return parser;
    }

    public Map<String, BundleAttributeParser> getMap() {
        return Collections.unmodifiableMap(this.parsers);
    }

    private BundleAttributeParser createBundleParser(JClassType bundleClass, XMLAttribute attribute) throws UnableToCompleteException {
        JMethod method;
        String templateResourceName = attribute.getName().split(":")[0];
        this.warn(attribute.getElement(), "\"%s\" is deprecated by <ui:with field='%s' type='%s.%s' />", BUNDLE_URI_SCHEME, templateResourceName, bundleClass.getPackage().getName(), bundleClass.getName());
        OwnerField field = this.getOwnerClass().getUiFieldForType(bundleClass);
        if (field != null) {
            if (!templateResourceName.equals(field.getName())) {
                this.die(attribute.getElement(), "Template %s has no \"xmlns:%s='urn:with:%s'\" for %s.%s#%s", this.templatePath, field.getName(), bundleClass.getQualifiedSourceName(), this.uiOwnerType.getPackage().getName(), this.uiOwnerType.getName(), field.getName());
            }
            if (field.isProvided()) {
                return new BundleAttributeParser(bundleClass, "owner." + field.getName(), false);
            }
        }
        if ((method = this.getOwnerClass().getUiFactoryMethod(bundleClass)) != null) {
            return new BundleAttributeParser(bundleClass, "owner." + method.getName() + "()", false);
        }
        return new BundleAttributeParser(bundleClass, "my" + bundleClass.getName().replace('.', '_') + "Instance", true);
    }

    private void die(XMLElement elem, String string, Object ... params) throws UnableToCompleteException {
        this.logger.die(elem, string, params);
    }

    private TypeOracle getOracle() {
        return this.oracle;
    }

    private OwnerClass getOwnerClass() {
        return this.ownerClass;
    }

    private void warn(XMLElement elem, String string, Object ... params) {
        this.logger.warn(elem, string, params);
    }
}

