/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class ClipboardCopier {
    private static ClipboardCopier instance = new ClipboardCopier();
    public static String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private Clipboard clipboard;

    public static ClipboardCopier getDefault() {
        return instance;
    }

    public void copy(IStructuredSelection selection, TextProvider provider) {
        this.copy(selection.toList(), provider);
    }

    public void copy(List<?> selection, TextProvider provider) {
        if (!selection.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object item : selection) {
                String textForElement = provider.getTextForElement(item);
                if (textForElement == null) continue;
                if (sb.length() > 0) {
                    sb.append(LINE_SEPARATOR);
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(textForElement);
            }
            if (sb.length() > 0) {
                this.copy(sb.toString());
            }
        }
    }

    public void copy(String text) {
        Assert.isNotNull((Object)text);
        Assert.isTrue((text.length() > 0 ? 1 : 0) != 0);
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(Display.getDefault());
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{text}, new Transfer[]{textTransfer});
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    public static interface TextProvider {
        public String getTextForElement(Object var1);
    }
}

