/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DocBaseBitSetIterator;
import org.apache.lucene.util.FixedBits;
import org.apache.lucene.util.RamUsageEstimator;

public final class FixedBitSet
extends BitSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
    private static final long[] ZEROES = new long[32];
    private final long[] bits;
    private final int numBits;
    private final int numWords;

    public static FixedBitSet ensureCapacity(FixedBitSet bits, int numBits) {
        long[] arr;
        if (numBits < bits.numBits) {
            return bits;
        }
        int numWords = FixedBitSet.bits2words(numBits);
        if (numWords >= (arr = bits.getBits()).length) {
            arr = ArrayUtil.grow(arr, numWords + 1);
        }
        return new FixedBitSet(arr, arr.length << 6);
    }

    public static int bits2words(int numBits) {
        return (numBits - 1 >> 6) + 1;
    }

    public static long intersectionCount(FixedBitSet a, FixedBitSet b) {
        long tot = 0L;
        int numCommonWords = Math.min(a.numWords, b.numWords);
        for (int i = 0; i < numCommonWords; ++i) {
            tot += (long)Long.bitCount(a.bits[i] & b.bits[i]);
        }
        return tot;
    }

    public static long unionCount(FixedBitSet a, FixedBitSet b) {
        int i;
        long tot = 0L;
        int numCommonWords = Math.min(a.numWords, b.numWords);
        for (i = 0; i < numCommonWords; ++i) {
            tot += (long)Long.bitCount(a.bits[i] | b.bits[i]);
        }
        for (i = numCommonWords; i < a.numWords; ++i) {
            tot += (long)Long.bitCount(a.bits[i]);
        }
        for (i = numCommonWords; i < b.numWords; ++i) {
            tot += (long)Long.bitCount(b.bits[i]);
        }
        return tot;
    }

    public static long andNotCount(FixedBitSet a, FixedBitSet b) {
        int i;
        long tot = 0L;
        int numCommonWords = Math.min(a.numWords, b.numWords);
        for (i = 0; i < numCommonWords; ++i) {
            tot += (long)Long.bitCount(a.bits[i] & (b.bits[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        for (i = numCommonWords; i < a.numWords; ++i) {
            tot += (long)Long.bitCount(a.bits[i]);
        }
        return tot;
    }

    public FixedBitSet(int numBits) {
        this.numBits = numBits;
        this.bits = new long[FixedBitSet.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public FixedBitSet(long[] storedBits, int numBits) {
        this.numWords = FixedBitSet.bits2words(numBits);
        if (this.numWords > storedBits.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + numBits + " bits");
        }
        this.numBits = numBits;
        this.bits = storedBits;
        assert (this.verifyGhostBitsClear());
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    private boolean verifyGhostBitsClear() {
        for (int i = this.numWords; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3F) == 0) {
            return true;
        }
        long mask = -1L << this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    @Override
    public int length() {
        return this.numBits;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bits);
    }

    public long[] getBits() {
        return this.bits;
    }

    @Override
    public int cardinality() {
        long tot = 0L;
        for (int i = 0; i < this.numWords; ++i) {
            tot += (long)Long.bitCount(this.bits[i]);
        }
        return Math.toIntExact(tot);
    }

    public int cardinality(int from, int to) {
        Objects.checkFromToIndex(from, to, this.length());
        int cardinality = 0;
        if ((from & 0x3F) != 0) {
            long bits = this.bits[from >> 6] >>> from;
            int numBitsTilNextWord = -from & 0x3F;
            if (to - from < numBitsTilNextWord) {
                return Long.bitCount(bits &= (1L << to - from) - 1L);
            }
            cardinality += Long.bitCount(bits);
            assert (((from += numBitsTilNextWord) & 0x3F) == 0);
        }
        int end = to >> 6;
        for (int i = from >> 6; i < end; ++i) {
            cardinality += Long.bitCount(this.bits[i]);
        }
        if ((to & 0x3F) != 0) {
            long bits = this.bits[to >> 6] << -to;
            cardinality += Long.bitCount(bits);
        }
        return cardinality;
    }

    @Override
    public int approximateCardinality() {
        int rangeLength = 16;
        int interval = 1024;
        if (this.numWords <= 1024) {
            return this.cardinality();
        }
        long popCount = 0L;
        int maxWord = 0;
        while (maxWord + 1024 < this.numWords) {
            for (int i = 0; i < 16; ++i) {
                popCount += (long)Long.bitCount(this.bits[maxWord + i]);
            }
            maxWord += 1024;
        }
        return (int)(popCount *= (long)(64 * this.numWords / maxWord));
    }

    @Override
    public boolean get(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = index >> 6;
        long bitmask = 1L << index;
        return (this.bits[i] & bitmask) != 0L;
    }

    @Override
    public void set(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    @Override
    public boolean getAndSet(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    @Override
    public void clear(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getAndClear(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    @Override
    public int nextSetBit(int index) {
        return this.nextSetBitInRange(index, this.numBits);
    }

    @Override
    public int nextSetBit(int start, int upperBound) {
        int res = this.nextSetBitInRange(start, upperBound);
        return res < upperBound ? res : Integer.MAX_VALUE;
    }

    private int nextSetBitInRange(int start, int upperBound) {
        int limit;
        assert (start >= 0 && start < this.numBits) : "index=" + start + ", numBits=" + this.numBits;
        assert (start < upperBound) : "index=" + start + ", upperBound=" + upperBound;
        assert (upperBound <= this.numBits) : "upperBound=" + upperBound + ", numBits=" + this.numBits;
        int i = start >> 6;
        long word = this.bits[i] >> start;
        if (word != 0L) {
            return start + Long.numberOfTrailingZeros(word);
        }
        int n = limit = upperBound == this.numBits ? this.numWords : FixedBitSet.bits2words(upperBound);
        while (++i < limit) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int prevSetBit(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int i = index >> 6;
        int subIndex = index & 0x3F;
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public void or(DocIdSetIterator iter) throws IOException {
        this.checkUnpositioned(iter);
        iter.nextDoc();
        iter.intoBitSet(Integer.MAX_VALUE, this, 0);
    }

    private static long readNBits(long[] bitSet, int from, int numBits) {
        assert (numBits > 0 && numBits < 64);
        long bits = bitSet[from >> 6] >>> from;
        int numBitsSoFar = 64 - (from & 0x3F);
        if (numBitsSoFar < numBits) {
            bits |= bitSet[(from >> 6) + 1] << -from;
        }
        return bits & (1L << numBits) - 1L;
    }

    public static void orRange(FixedBitSet source, int sourceFrom, FixedBitSet dest, int destFrom, int length) {
        assert (length >= 0);
        Objects.checkFromIndexSize(sourceFrom, length, source.length());
        Objects.checkFromIndexSize(destFrom, length, dest.length());
        if (length == 0) {
            return;
        }
        long[] sourceBits = source.getBits();
        long[] destBits = dest.getBits();
        if ((destFrom & 0x3F) != 0) {
            int numBitsNeeded = Math.min(-destFrom & 0x3F, length);
            long bits = FixedBitSet.readNBits(sourceBits, sourceFrom, numBitsNeeded) << destFrom;
            int n = destFrom >> 6;
            destBits[n] = destBits[n] | bits;
            sourceFrom += numBitsNeeded;
            destFrom += numBitsNeeded;
            length -= numBitsNeeded;
        }
        if (length == 0) {
            return;
        }
        assert ((destFrom & 0x3F) == 0);
        int numFullWords = length >> 6;
        int sourceWordFrom = sourceFrom >> 6;
        int destWordFrom = destFrom >> 6;
        if ((sourceFrom & 0x3F) == 0) {
            for (i = 0; i < numFullWords; ++i) {
                int n = destWordFrom + i;
                destBits[n] = destBits[n] | sourceBits[sourceWordFrom + i];
            }
        } else {
            for (i = 0; i < numFullWords; ++i) {
                int n = destWordFrom + i;
                destBits[n] = destBits[n] | (sourceBits[sourceWordFrom + i] >>> sourceFrom | sourceBits[sourceWordFrom + i + 1] << -sourceFrom);
            }
        }
        sourceFrom += numFullWords << 6;
        destFrom += numFullWords << 6;
        if ((length -= numFullWords << 6) > 0) {
            long bits = FixedBitSet.readNBits(sourceBits, sourceFrom, length);
            int n = destFrom >> 6;
            destBits[n] = destBits[n] | bits;
        }
    }

    public static void andRange(FixedBitSet source, int sourceFrom, FixedBitSet dest, int destFrom, int length) {
        assert (length >= 0) : length;
        Objects.checkFromIndexSize(sourceFrom, length, source.length());
        Objects.checkFromIndexSize(destFrom, length, dest.length());
        if (length == 0) {
            return;
        }
        long[] sourceBits = source.getBits();
        long[] destBits = dest.getBits();
        if ((destFrom & 0x3F) != 0) {
            int numBitsNeeded = Math.min(-destFrom & 0x3F, length);
            long bits = FixedBitSet.readNBits(sourceBits, sourceFrom, numBitsNeeded) << destFrom;
            int n = destFrom >> 6;
            destBits[n] = destBits[n] & (bits |= (1L << numBitsNeeded) - 1L << destFrom ^ 0xFFFFFFFFFFFFFFFFL);
            sourceFrom += numBitsNeeded;
            destFrom += numBitsNeeded;
            length -= numBitsNeeded;
        }
        if (length == 0) {
            return;
        }
        assert ((destFrom & 0x3F) == 0);
        int numFullWords = length >> 6;
        int sourceWordFrom = sourceFrom >> 6;
        int destWordFrom = destFrom >> 6;
        if ((sourceFrom & 0x3F) == 0) {
            for (i = 0; i < numFullWords; ++i) {
                int n = destWordFrom + i;
                destBits[n] = destBits[n] & sourceBits[sourceWordFrom + i];
            }
        } else {
            for (i = 0; i < numFullWords; ++i) {
                int n = destWordFrom + i;
                destBits[n] = destBits[n] & (sourceBits[sourceWordFrom + i] >>> sourceFrom | sourceBits[sourceWordFrom + i + 1] << -sourceFrom);
            }
        }
        sourceFrom += numFullWords << 6;
        destFrom += numFullWords << 6;
        if ((length -= numFullWords << 6) > 0) {
            long bits = FixedBitSet.readNBits(sourceBits, sourceFrom, length);
            int n = destFrom >> 6;
            destBits[n] = destBits[n] & (bits |= -1L << length);
        }
    }

    public void or(FixedBitSet other) {
        FixedBitSet.orRange(other, 0, this, 0, other.length());
    }

    public void xor(FixedBitSet other) {
        this.xor(other.bits, other.numWords);
    }

    public void xor(DocIdSetIterator iter) throws IOException {
        this.checkUnpositioned(iter);
        if (BitSetIterator.getFixedBitSetOrNull(iter) != null) {
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter);
            this.xor(bits);
        } else {
            int doc;
            while ((doc = iter.nextDoc()) < this.numBits) {
                this.flip(doc);
            }
        }
    }

    private void xor(long[] otherBits, int otherNumWords) {
        assert (otherNumWords <= this.numWords) : "numWords=" + this.numWords + ", other.numWords=" + otherNumWords;
        long[] thisBits = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisBits[n] = thisBits[n] ^ otherBits[pos];
        }
    }

    public boolean intersects(FixedBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void and(FixedBitSet other) {
        this.and(other.bits, other.numWords);
    }

    private void and(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.numWords > otherNumWords) {
            Arrays.fill(thisArr, otherNumWords, this.numWords, 0L);
        }
    }

    public void andNot(DocIdSetIterator iter) throws IOException {
        if (BitSetIterator.getFixedBitSetOrNull(iter) != null) {
            this.checkUnpositioned(iter);
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter);
            assert (bits != null);
            this.andNot(bits);
        } else if (iter instanceof DocBaseBitSetIterator) {
            this.checkUnpositioned(iter);
            DocBaseBitSetIterator baseIter = (DocBaseBitSetIterator)iter;
            this.andNot(baseIter.getDocBase() >> 6, baseIter.getBitSet());
        } else {
            this.checkUnpositioned(iter);
            int doc = iter.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.clear(doc);
                doc = iter.nextDoc();
            }
        }
    }

    public void andNot(FixedBitSet other) {
        this.andNot(0, other.bits, other.numWords);
    }

    private void andNot(int otherOffsetWords, FixedBitSet other) {
        this.andNot(otherOffsetWords, other.bits, other.numWords);
    }

    private void andNot(int otherOffsetWords, long[] otherArr, int otherNumWords) {
        int pos = Math.min(this.numWords - otherOffsetWords, otherNumWords);
        long[] thisArr = this.bits;
        while (--pos >= 0) {
            int n = pos + otherOffsetWords;
            thisArr[n] = thisArr[n] & (otherArr[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean scanIsEmpty() {
        int count = this.numWords;
        for (int i = 0; i < count; i += ZEROES.length) {
            int cmpLen = Math.min(ZEROES.length, this.bits.length - i);
            if (Arrays.equals(this.bits, i, i + cmpLen, ZEROES, 0, cmpLen)) continue;
            return false;
        }
        return true;
    }

    public void flip(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits);
        assert (endIndex >= 0 && endIndex <= this.numBits);
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public void flip(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void set(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0 && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0 && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, 0L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] & endmask;
    }

    public FixedBitSet clone() {
        long[] bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bits, 0, this.numWords);
        return new FixedBitSet(bits, this.numBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedBitSet)) {
            return false;
        }
        FixedBitSet other = (FixedBitSet)o;
        if (this.numBits != other.numBits) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    public static FixedBitSet copyOf(Bits bits) {
        if (bits instanceof FixedBits) {
            FixedBits fixedBits = (FixedBits)bits;
            bits = fixedBits.bitSet;
        }
        if (bits instanceof FixedBitSet) {
            return ((FixedBitSet)bits).clone();
        }
        int length = bits.length();
        FixedBitSet bitSet = new FixedBitSet(length);
        bitSet.set(0, length);
        for (int i = 0; i < length; ++i) {
            if (bits.get(i)) continue;
            bitSet.clear(i);
        }
        return bitSet;
    }

    public Bits asReadOnlyBits() {
        return new FixedBits(this.bits, this.numBits);
    }

    @Override
    public void applyMask(FixedBitSet bitSet, int offset) {
        int length = Math.min(bitSet.length(), this.length() - offset);
        if (length >= 0) {
            FixedBitSet.andRange(this, offset, bitSet, 0, length);
        }
        if (length < bitSet.length() && bitSet.nextSetBit(Math.max(0, length)) != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Some bits are set beyond the end of live docs");
        }
    }

    public void forEach(int from, int to, int base, CheckedIntConsumer<IOException> consumer) throws IOException {
        Objects.checkFromToIndex(from, to, this.length());
        if ((from & 0x3F) != 0) {
            long bits = this.bits[from >> 6] >>> from;
            int numBitsTilNextWord = -from & 0x3F;
            if (to - from < numBitsTilNextWord) {
                FixedBitSet.forEach(bits &= (1L << to - from) - 1L, from + base, consumer);
                return;
            }
            FixedBitSet.forEach(bits, from + base, consumer);
            assert (((from += numBitsTilNextWord) & 0x3F) == 0);
        }
        int end = to >> 6;
        for (int i = from >> 6; i < end; ++i) {
            FixedBitSet.forEach(this.bits[i], base + (i << 6), consumer);
        }
        if ((to & 0x3F) != 0) {
            long bits = this.bits[to >> 6] & (1L << to) - 1L;
            FixedBitSet.forEach(bits, base + (to & 0xFFFFFFC0), consumer);
        }
    }

    private static void forEach(long bits, int base, CheckedIntConsumer<IOException> consumer) throws IOException {
        while (bits != 0L) {
            int ntz = Long.numberOfTrailingZeros(bits);
            consumer.accept(base + ntz);
            bits ^= 1L << ntz;
        }
    }
}

