/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ListBlock
extends Block {
    static final Pattern pattern = Pattern.compile("\\s*((?:[*]+)|(?:#+))\\s*(.+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    public int processLineContent(String line, int offset) {
        boolean continuation = false;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            String listSpec = this.matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec.charAt(0));
            offset = this.matcher.start(2);
            this.listState.push(new ListState(1, type));
            this.builder.beginBlock(type, new Attributes());
            this.adjustLevel(level, type);
        } else {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
            String listSpec = matcher.group(1);
            int lineLevel = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec.charAt(0));
            offset = matcher.start(2);
            continuation = this.adjustLevel(lineLevel, type);
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (!continuation && listState.openItem) {
            listState.openItem = false;
            this.builder.endBlock();
        }
        if (!listState.openItem) {
            listState.openItem = true;
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private boolean adjustLevel(int lineLevel, DocumentBuilder.BlockType type) {
        boolean continuation = false;
        ListState previousState = this.listState.peek();
        while (lineLevel != previousState.level || previousState.type != type) {
            if (lineLevel > previousState.level) {
                if (!previousState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    previousState.openItem = true;
                }
                this.listState.push(new ListState(previousState.level + 1, type));
                this.builder.beginBlock(type, new Attributes());
            } else if (lineLevel == previousState.level && previousState.type == type) {
                if (previousState.openItem) {
                    this.builder.endBlock();
                    previousState.openItem = false;
                }
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    this.listState.push(new ListState(1, type));
                    this.builder.beginBlock(type, new Attributes());
                }
            }
            previousState = this.listState.peek();
        }
        return continuation;
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length();
    }

    private DocumentBuilder.BlockType calculateType(char ch) {
        return ch == '#' ? DocumentBuilder.BlockType.NUMERIC_LIST : DocumentBuilder.BlockType.BULLETED_LIST;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        if (lineOffset == 0) {
            String listSpec;
            this.matcher = pattern.matcher(line);
            if (this.matcher.matches() && this.calculateLevel(listSpec = this.matcher.group(1)) == 1) {
                return true;
            }
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type) {
            this.level = level;
            this.type = type;
        }
    }
}

