/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTaskHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int index;
        String content;
        int contentOffset;
        IDocument document = textViewer.getDocument();
        if (document == null || document.getLength() == 0) {
            return null;
        }
        try {
            if (region.getLength() == 0) {
                IRegion lineInfo = document.getLineInformationOfOffset(region.getOffset());
                int lineLength = lineInfo.getLength();
                int lineOffset = lineInfo.getOffset();
                int lineEnd = lineOffset + lineLength;
                int regionEnd = region.getOffset() + region.getLength();
                if (lineOffset < region.getOffset()) {
                    regionLength = Math.max(regionEnd, lineEnd) - lineOffset;
                    contentOffset = lineOffset;
                    content = document.get(lineOffset, regionLength);
                    index = region.getOffset() - lineOffset;
                } else {
                    regionLength = Math.max(regionEnd, lineEnd) - region.getOffset();
                    contentOffset = region.getOffset();
                    content = document.get(contentOffset, regionLength);
                    index = 0;
                }
            } else {
                content = document.get(region.getOffset(), region.getLength());
                contentOffset = region.getOffset();
                index = -1;
            }
        }
        catch (BadLocationException ex) {
            return null;
        }
        List<IHyperlink> hyperlinks = this.detectHyperlinks(textViewer, content, index, contentOffset);
        if (hyperlinks == null) {
            return null;
        }
        if (region.getLength() == 0) {
            Iterator<IHyperlink> it = hyperlinks.iterator();
            while (it.hasNext()) {
                IHyperlink hyperlink = it.next();
                IRegion hyperlinkRegion = hyperlink.getHyperlinkRegion();
                if (this.isInRegion(region, hyperlinkRegion)) continue;
                it.remove();
            }
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    protected abstract List<IHyperlink> detectHyperlinks(ITextViewer var1, String var2, int var3, int var4);

    private boolean isInRegion(IRegion detectInRegion, IRegion hyperlinkRegion) {
        return detectInRegion.getOffset() >= hyperlinkRegion.getOffset() && detectInRegion.getOffset() <= hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
    }

    protected List<TaskRepository> getTaskRepositories(ITextViewer textViewer) {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        TaskRepository selectedRepository = this.getTaskRepository(textViewer);
        if (selectedRepository != null) {
            repositories.add(selectedRepository);
        } else {
            repositories.addAll(TasksUi.getRepositoryManager().getAllRepositories());
        }
        return repositories;
    }

    protected TaskRepository getTaskRepository(ITextViewer textViewer) {
        IEditorInput input;
        IWorkbenchPart part;
        IWorkbenchPage activePage;
        IWorkbenchWindow window;
        TaskRepository repository = (TaskRepository)this.getAdapter(TaskRepository.class);
        if (repository != null) {
            return repository;
        }
        IResource resource = (IResource)this.getAdapter(IResource.class);
        if (resource == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = window.getActivePage()) != null && (part = activePage.getActivePart()) instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) != null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        if (resource != null) {
            return TasksUiPlugin.getDefault().getRepositoryForResource(resource);
        }
        return null;
    }
}

