/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BugzillaCustomField
implements Serializable {
    private static final long serialVersionUID = 8268371206426652131L;
    public static final String CUSTOM_FIELD_PREFIX = "cf_";
    private final String name;
    private final String description;
    private List<String> options = new ArrayList<String>();
    private final int type;
    private final FieldType fieldType;
    private final boolean enterBug;

    public BugzillaCustomField(String description, String name, String type, String enterBug) {
        this.description = description;
        this.name = name;
        this.type = this.parseInt(type);
        this.fieldType = FieldType.convert(type);
        this.enterBug = "1".equals(enterBug);
    }

    private int parseInt(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    @Deprecated
    public int getType() {
        return this.type;
    }

    @Deprecated
    public String getTypeDesc() {
        return this.getFieldType().toString();
    }

    public boolean isEnterBug() {
        return this.enterBug;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public static enum FieldType {
        UNKNOWN,
        FreeText,
        DropDown,
        MultipleSelection,
        LargeText,
        DateTime,
        BugId;


        private static int parseInt(String type) {
            try {
                return Integer.parseInt(type);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public String toString() {
            return switch (this.ordinal()) {
                case 1 -> "Free Text";
                case 2 -> "Drop Down";
                case 3 -> "Multiple-Selection Box";
                case 4 -> "Large Text Box";
                case 5 -> "Date/Time";
                case 6 -> "Bug ID";
                default -> super.toString();
            };
        }

        public static FieldType convert(String change) {
            return switch (FieldType.parseInt(change)) {
                case 1 -> FreeText;
                case 2 -> DropDown;
                case 3 -> MultipleSelection;
                case 4 -> LargeText;
                case 5 -> DateTime;
                case 6 -> BugId;
                default -> UNKNOWN;
            };
        }
    }
}

