/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.rest;

import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.util.Map;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;

public class ReviewerInfo
extends AccountInfo {
    private final String kind = "gerritcodereview#reviewer";
    private Map<String, String> approvals;

    public String getKind() {
        return "gerritcodereview#reviewer";
    }

    public Map<String, String> getApprovals() {
        return this.approvals;
    }

    public ApprovalDetail toApprovalDetail(PatchSet currentPatchSet) {
        Account.Id accountId = new Account.Id(this.getId());
        ApprovalDetail approvalDetail = new ApprovalDetail(accountId);
        Map<String, String> map = this.getApprovals();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ApprovalCategory.Id categoryId = ApprovalUtil.findCategoryIdByName(entry.getKey().replace('-', ' '));
                if (categoryId == null) continue;
                PatchSetApproval patchSetApproval = new PatchSetApproval(new PatchSetApproval.Key(currentPatchSet.getId(), accountId, categoryId), ApprovalUtil.parseShort(entry.getValue()));
                approvalDetail.add(patchSetApproval);
            }
        }
        return approvalDetail;
    }

    public com.google.gerrit.common.data.AccountInfo toAccountInfo() {
        Account.Id accountId = new Account.Id(this.getId());
        Account account = new Account(accountId);
        account.setFullName(this.getName());
        account.setPreferredEmail(this.getEmail());
        com.google.gerrit.common.data.AccountInfo accountInfo = new com.google.gerrit.common.data.AccountInfo(account);
        return accountInfo;
    }
}

