/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gwtjsonrpc.server.ActiveCall;
import com.google.gwtjsonrpc.server.JsonServlet;
import com.google.gwtjsonrpc.server.NoSuchRemoteMethodException;
import java.lang.reflect.Type;

final class CallDeserializer<CallType extends ActiveCall>
implements JsonDeserializer<CallType>,
InstanceCreator<CallType> {
    private final CallType req;
    private final JsonServlet<? extends ActiveCall> server;

    CallDeserializer(CallType call, JsonServlet<CallType> jsonServlet) {
        this.req = call;
        this.server = jsonServlet;
    }

    public CallType createInstance(Type type) {
        return this.req;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException, NoSuchRemoteMethodException {
        JsonElement xsrfKey;
        String v;
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected object");
        }
        JsonObject in = json.getAsJsonObject();
        ((ActiveCall)this.req).id = in.get("id");
        JsonElement jsonrpc = in.get("jsonrpc");
        JsonElement version = in.get("version");
        if (CallDeserializer.isString(jsonrpc) && version == null) {
            v = jsonrpc.getAsString();
            if (!"2.0".equals(v)) throw new JsonParseException("Expected jsonrpc=2.0");
            ((ActiveCall)this.req).versionName = "jsonrpc";
            ((ActiveCall)this.req).versionValue = jsonrpc;
        } else {
            if (!CallDeserializer.isString(version) || jsonrpc != null) throw new JsonParseException("Expected version=1.1 or jsonrpc=2.0");
            v = version.getAsString();
            if (!"1.1".equals(v)) throw new JsonParseException("Expected version=1.1");
            ((ActiveCall)this.req).versionName = "version";
            ((ActiveCall)this.req).versionValue = version;
        }
        JsonElement method = in.get("method");
        if (!CallDeserializer.isString(method)) {
            throw new JsonParseException("Expected method name as string");
        }
        ((ActiveCall)this.req).method = this.server.lookupMethod(method.getAsString());
        if (((ActiveCall)this.req).method == null) {
            throw new NoSuchRemoteMethodException();
        }
        JsonElement callback = in.get("callback");
        if (callback != null) {
            if (!CallDeserializer.isString(callback)) {
                throw new JsonParseException("Expected callback as string");
            }
            ((ActiveCall)this.req).callback = callback.getAsString();
        }
        if ((xsrfKey = in.get("xsrfKey")) != null) {
            if (!CallDeserializer.isString(xsrfKey)) {
                throw new JsonParseException("Expected xsrfKey as string");
            }
            ((ActiveCall)this.req).xsrfKeyIn = xsrfKey.getAsString();
        }
        Type[] paramTypes = ((ActiveCall)this.req).method.getParamTypes();
        JsonElement params = in.get("params");
        if (params != null) {
            if (!params.isJsonArray()) {
                throw new JsonParseException("Expected params array");
            }
            JsonArray paramsArray = params.getAsJsonArray();
            if (paramsArray.size() != paramTypes.length) {
                throw new JsonParseException("Expected " + paramTypes.length + " parameter values in params array");
            }
            Object[] r = new Object[paramTypes.length];
            for (int i = 0; i < r.length; ++i) {
                JsonElement v2 = paramsArray.get(i);
                if (v2 == null) continue;
                r[i] = context.deserialize(v2, paramTypes[i]);
            }
            ((ActiveCall)this.req).params = r;
            return this.req;
        } else {
            if (paramTypes.length != 0) {
                throw new JsonParseException("Expected params array");
            }
            ((ActiveCall)this.req).params = JsonServlet.NO_PARAMS;
        }
        return this.req;
    }

    private static boolean isString(JsonElement e) {
        return e != null && e.isJsonPrimitive() && e.getAsJsonPrimitive().isString();
    }
}

