/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.ProductionFactory;
import org.eclipse.xtext.util.formallang.ProductionFormatter;

public class GrammarAlias {

    public static class AbstractElementAlias {
        protected final boolean many;
        protected final boolean optional;
        protected AbstractElementAlias parent;

        public AbstractElementAlias(boolean many, boolean optional) {
            this.many = many;
            this.optional = optional;
        }

        public AbstractElementAlias getParent() {
            return this.parent;
        }

        public boolean isMany() {
            return this.many;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            GrammarElementTitleSwitch t2s = new GrammarElementTitleSwitch().showAssignments().hideCardinality();
            ProductionFormatter formatter2 = new ProductionFormatter().setTokenToString((Function)t2s);
            return (String)formatter2.apply((Object)new GrammarAliasAdapter(this));
        }
    }

    public static class AlternativeAlias
    extends CompoundAlias {
        protected final Set<AbstractElementAlias> children = Sets.newLinkedHashSet();

        public AlternativeAlias(boolean many, boolean optional, AbstractElementAlias ... children) {
            super(many, optional);
            this.addChildren(children);
        }

        public AlternativeAlias(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            super(many, optional);
            this.addChildren(children);
        }

        public Set<AbstractElementAlias> getChildren() {
            return this.children;
        }
    }

    public static abstract class CompoundAlias
    extends AbstractElementAlias {
        public CompoundAlias(boolean many, boolean optional) {
            super(many, optional);
        }

        public void addChildren(AbstractElementAlias ... children) {
            AbstractElementAlias[] abstractElementAliasArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractElementAlias child = abstractElementAliasArray[n2];
                child.parent = this;
                this.getChildren().add(child);
                ++n2;
            }
        }

        public void addChildren(Iterable<AbstractElementAlias> children) {
            for (AbstractElementAlias child : children) {
                child.parent = this;
                this.getChildren().add(child);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CompoundAlias other = (CompoundAlias)obj;
            return this.many == other.many && this.optional == other.optional && this.getChildren().equals(other.getChildren());
        }

        public abstract Collection<AbstractElementAlias> getChildren();

        public int hashCode() {
            int result = this.getChildren().hashCode();
            if (this.many) {
                result *= 7;
            }
            if (this.optional) {
                result *= 23;
            }
            return result;
        }
    }

    public static class GrammarAliasAdapter
    implements Production<AbstractElementAlias, AbstractElement> {
        protected AbstractElementAlias root;

        public GrammarAliasAdapter(AbstractElementAlias root) {
            this.root = root;
        }

        public Iterable<AbstractElementAlias> getAlternativeChildren(AbstractElementAlias ele) {
            return ele instanceof AlternativeAlias ? ((AlternativeAlias)ele).getChildren() : null;
        }

        public AbstractElementAlias getParent(AbstractElementAlias ele) {
            return ele.getParent();
        }

        public Iterable<AbstractElementAlias> getSequentialChildren(AbstractElementAlias ele) {
            return ele instanceof GroupAlias ? ((GroupAlias)ele).getChildren() : null;
        }

        public AbstractElement getToken(AbstractElementAlias owner) {
            return owner instanceof TokenAlias ? ((TokenAlias)owner).getToken() : null;
        }

        public Iterable<AbstractElementAlias> getUnorderedChildren(AbstractElementAlias ele) {
            return ele instanceof UnorderedGroupAlias ? ((UnorderedGroupAlias)ele).getChildren() : null;
        }

        public boolean isMany(AbstractElementAlias ele) {
            return ele.isMany();
        }

        public boolean isOptional(AbstractElementAlias ele) {
            return ele.isOptional();
        }

        public AbstractElementAlias getRoot() {
            return this.root;
        }
    }

    public static class GrammarAliasFactory
    implements ProductionFactory<AbstractElementAlias, AbstractElement> {
        public AbstractElementAlias createForAlternativeChildren(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            return new AlternativeAlias(many, optional, children);
        }

        public AbstractElementAlias createForSequentialChildren(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            return new GroupAlias(many, optional, children);
        }

        public AbstractElementAlias createForToken(boolean many, boolean optional, AbstractElement token) {
            return new TokenAlias(many, optional, token);
        }

        public AbstractElementAlias createForUnordertedChildren(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            return new UnorderedGroupAlias(many, optional, children);
        }
    }

    public static class GroupAlias
    extends CompoundAlias {
        protected final List<AbstractElementAlias> children = Lists.newArrayList();

        public GroupAlias(boolean many, boolean optional, AbstractElementAlias ... children) {
            super(many, optional);
            this.addChildren(children);
        }

        public GroupAlias(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            super(many, optional);
            this.addChildren(children);
        }

        public List<AbstractElementAlias> getChildren() {
            return this.children;
        }
    }

    public static class TokenAlias
    extends AbstractElementAlias {
        protected final AbstractElement token;

        public TokenAlias(boolean many, boolean optional, AbstractElement token) {
            super(many, optional);
            this.token = token;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TokenAlias other = (TokenAlias)obj;
            return this.many == other.many && this.optional == other.optional && Objects.equals(this.token, other.token);
        }

        public AbstractElement getToken() {
            return this.token;
        }

        public int hashCode() {
            int result = this.token.hashCode();
            if (this.many) {
                result *= 7;
            }
            if (this.optional) {
                result *= 23;
            }
            return result;
        }
    }

    public static class UnorderedGroupAlias
    extends CompoundAlias {
        protected final Set<AbstractElementAlias> children = Sets.newLinkedHashSet();

        public UnorderedGroupAlias(boolean many, boolean optional, AbstractElementAlias ... children) {
            super(many, optional);
            this.addChildren(children);
        }

        public UnorderedGroupAlias(boolean many, boolean optional, Iterable<AbstractElementAlias> children) {
            super(many, optional);
            this.addChildren(children);
        }

        public Set<AbstractElementAlias> getChildren() {
            return this.children;
        }
    }
}

