/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.action.distortion.Distortion;

public class FisheyeDistortion
extends Distortion {
    private double dx;
    private double dy;
    private double sz = 3.0;

    public FisheyeDistortion() {
        this(4.0);
    }

    public FisheyeDistortion(double dfactor) {
        this(dfactor, dfactor);
    }

    public FisheyeDistortion(double xfactor, double yfactor) {
        this.dx = xfactor;
        this.dy = yfactor;
        this.m_distortX = this.dx > 0.0;
        this.m_distortY = this.dy > 0.0;
    }

    public double getXDistortionFactor() {
        return this.dx;
    }

    public void setXDistortionFactor(double d) {
        this.dx = d;
        this.m_distortX = this.dx > 0.0;
    }

    public double getYDistortionFactor() {
        return this.dy;
    }

    public void setYDistortionFactor(double d) {
        this.dy = d;
        this.m_distortY = this.dy > 0.0;
    }

    protected double distortX(double x, Point2D anchor, Rectangle2D bounds) {
        return this.fisheye(x, anchor.getX(), this.dx, bounds.getMinX(), bounds.getMaxX());
    }

    protected double distortY(double y, Point2D anchor, Rectangle2D bounds) {
        return this.fisheye(y, anchor.getY(), this.dy, bounds.getMinY(), bounds.getMaxY());
    }

    protected double distortSize(Rectangle2D bbox, double x, double y, Point2D anchor, Rectangle2D bounds) {
        double sf;
        if (!this.m_distortX && !this.m_distortY) {
            return 1.0;
        }
        double fx = 1.0;
        double fy = 1.0;
        if (this.m_distortX) {
            double xx;
            double ax = anchor.getX();
            double minX = bbox.getMinX();
            double maxX = bbox.getMaxX();
            double d = xx = Math.abs(minX - ax) > Math.abs(maxX - ax) ? minX : maxX;
            if (xx < bounds.getMinX() || xx > bounds.getMaxX()) {
                xx = xx == minX ? maxX : minX;
            }
            fx = this.fisheye(xx, ax, this.dx, bounds.getMinX(), bounds.getMaxX());
            fx = Math.abs(x - fx) / bbox.getWidth();
        }
        if (this.m_distortY) {
            double yy;
            double ay = anchor.getY();
            double minY = bbox.getMinY();
            double maxY = bbox.getMaxY();
            double d = yy = Math.abs(minY - ay) > Math.abs(maxY - ay) ? minY : maxY;
            if (yy < bounds.getMinY() || yy > bounds.getMaxY()) {
                yy = yy == minY ? maxY : minY;
            }
            fy = this.fisheye(yy, ay, this.dy, bounds.getMinY(), bounds.getMaxY());
            fy = Math.abs(y - fy) / bbox.getHeight();
        }
        double d = !this.m_distortY ? fx : (sf = !this.m_distortX ? fy : Math.min(fx, fy));
        if (Double.isInfinite(sf) || Double.isNaN(sf)) {
            return 1.0;
        }
        return this.sz * sf;
    }

    private double fisheye(double x, double a, double d, double min, double max) {
        if (d != 0.0) {
            double m;
            boolean left = x < a;
            double d2 = m = left ? a - min : max - a;
            if (m == 0.0) {
                m = max - min;
            }
            double v = Math.abs(x - a) / m;
            v = (d + 1.0) / (d + 1.0 / v);
            return (double)(left ? -1 : 1) * m * v + a;
        }
        return x;
    }
}

