/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.DBAdapterRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public interface IDBAdapter {
    public static final IRegistry<String, IDBAdapter> REGISTRY = DBAdapterRegistry.INSTANCE;

    public String getName();

    public String getVersion();

    public boolean isCaseSensitive();

    public String getDefaultSchemaName(Connection var1);

    public IDBConnectionProvider createConnectionProvider(DataSource var1);

    public Connection modifyConnection(Connection var1);

    public void createSchema(Connection var1, String var2);

    public IDBSchema readSchema(Connection var1, String var2);

    public void readSchema(Connection var1, IDBSchema var2);

    public void updateSchema(Connection var1, IDBSchema var2, IDBSchemaDelta var3) throws DBException;

    public Set<IDBTable> createTables(Iterable<? extends IDBTable> var1, Connection var2) throws DBException;

    public boolean createTable(IDBTable var1, Statement var2) throws DBException;

    public Collection<IDBTable> dropTables(Iterable<? extends IDBTable> var1, Connection var2) throws DBException;

    public boolean dropTable(IDBTable var1, Statement var2);

    public String[] getReservedWords();

    public boolean isReservedWord(String var1);

    public int getMaxTableNameLength();

    public int getMaxFieldNameLength();

    public int getFieldLength(DBType var1);

    public boolean isTypeIndexable(DBType var1);

    public DBType adaptType(DBType var1);

    public boolean isValidFirstChar(char var1);

    public boolean isDuplicateKeyException(SQLException var1);

    public boolean isTableNotFoundException(SQLException var1);

    public boolean isColumnNotFoundException(SQLException var1);

    public String sqlRenameField(IDBField var1, String var2);

    public String sqlModifyField(IDBField var1);

    public String sqlCharIndex(Object var1, Object var2);

    public String sqlSubstring(Object var1, Object var2, Object var3);

    public String sqlSubstring(Object var1, Object var2);

    public String sqlConcat(Object ... var1);

    @Deprecated
    public Driver getJDBCDriver();

    @Deprecated
    public DataSource createJDBCDataSource();
}

