/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.StatementBatcher;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.properties.IPropertiesContainer;

public interface IModelEvolutionSupport
extends INotifier.INotifier2 {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.db.modelEvolutionSupports";

    public IDBStore getStore();

    public void setStore(IDBStore var1);

    public void evolveModels() throws SQLException;

    public static interface Context
    extends CDOTimeProvider,
    IPropertiesContainer {
        public IModelEvolutionSupport getModelEvolutionSupport();

        public IDBStore getStore();

        public List<Model> getModels();

        public List<Model> getChangedModels();

        public Map<String, EPackage> getStoredPackages();

        public EMFUtil.TreeMapping<EObject> getElementMappings();

        public <T extends EObject> T getRegisteredElement(T var1);

        public Map<Integer, Integer> getEnumLiteralChanges(EEnum var1);

        public <F extends EStructuralFeature> void handleFeatureIDChanges(EClass var1, Function<EClass, Collection<F>> var2, BiConsumer<Integer, Integer> var3);

        public StatementBatcher createStatementBatcher(Connection var1) throws SQLException;

        public void log(Object var1);

        public int getTotalUpdateCount();
    }

    public static final class Model {
        private final String id;
        private final CDOPackageUnit.Type originalType;
        private final long timeStamp;
        private final EPackage storedPackage;
        private final EPackage registeredPackage;
        private final boolean changed;

        public Model(String id, CDOPackageUnit.Type originalType, long timeStamp, EPackage storedPackage, EPackage registeredPackage) {
            this.id = id;
            this.originalType = originalType;
            this.timeStamp = timeStamp;
            this.storedPackage = storedPackage;
            this.registeredPackage = registeredPackage;
            this.changed = registeredPackage != null && !EcoreUtil.equals((EObject)storedPackage, (EObject)registeredPackage);
        }

        public String getID() {
            return this.id;
        }

        public CDOPackageUnit.Type getOriginalType() {
            return this.originalType;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public EPackage getStoredPackage() {
            return this.storedPackage;
        }

        public EPackage getRegisteredPackage() {
            return this.registeredPackage;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isRemoved() {
            return this.registeredPackage == null;
        }

        public String toString() {
            return "Model[id=" + this.id + ", originalType=" + this.originalType + ", timeStamp=" + this.timeStamp + "]";
        }

        public static interface Loader {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.db.modelLoaders";

            public List<Model> loadModels(IDBStore var1) throws SQLException;
        }
    }
}

