/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tcp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public final class TCPUtil {
    public static final String FACTORY_TYPE = "tcp";
    public static final String PORT_SEPARATOR = ":";
    public static final String CREDENTIALS_SEPARATOR = "@";

    private TCPUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        OM.BUNDLE.prepareContainer(container);
    }

    public static ITCPAcceptor getAcceptor(IManagedContainer container, String description) {
        return (ITCPAcceptor)container.getElement("org.eclipse.net4j.acceptors", FACTORY_TYPE, description);
    }

    public static ITCPConnector getConnector(IManagedContainer container, String description) {
        return (ITCPConnector)container.getElement("org.eclipse.net4j.connectors", FACTORY_TYPE, description);
    }

    public static final class AcceptorData {
        private static final int NO_PORT = -1;
        private String address = "0.0.0.0";
        private int port = -1;

        public AcceptorData() {
        }

        public AcceptorData(String address, int port) {
            this.address = address;
            this.port = port;
        }

        public AcceptorData(String description) {
            if (!StringUtil.isEmpty((String)description)) {
                String[] tokens = description.split(TCPUtil.PORT_SEPARATOR);
                if (!StringUtil.isEmpty((String)tokens[0])) {
                    this.address = tokens[0];
                }
                if (tokens.length > 1 && !StringUtil.isEmpty((String)tokens[1])) {
                    this.port = Integer.parseInt(tokens[1]);
                }
            }
        }

        public AcceptorData(ITCPAcceptor acceptor) {
            this(acceptor.getAddress(), acceptor.getPort());
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            if (this.port == -1) {
                return ITCPAcceptor.DEFAULT_PORT;
            }
            return this.port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AcceptorData other = (AcceptorData)obj;
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            String result;
            String string = result = StringUtil.isEmpty((String)this.address) ? "0.0.0.0" : this.address;
            if (this.port != -1) {
                result = String.valueOf(result) + TCPUtil.PORT_SEPARATOR + this.port;
            }
            return result;
        }
    }

    public static final class ConnectorData {
        private static final int NO_PORT = -1;
        private String host;
        private int port = -1;
        private String userID;

        public ConnectorData() {
        }

        public ConnectorData(String host, int port, String userID) {
            this.host = host;
            this.port = port;
            this.userID = userID;
        }

        public ConnectorData(String description) {
            if (!StringUtil.isEmpty((String)description)) {
                try {
                    URI uri = ConnectorData.parse(description);
                    this.userID = uri.getUserInfo();
                    this.host = uri.getHost();
                    this.port = uri.getPort();
                }
                catch (URISyntaxException ex) {
                    throw new ProductCreationException((Throwable)ex);
                }
            }
        }

        public ConnectorData(ITCPConnector connector) {
            this(connector.getHost(), connector.getPort(), connector.getUserID());
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            if (this.port == -1) {
                return ITCPConnector.DEFAULT_PORT;
            }
            return this.port;
        }

        public String getUserID() {
            return this.userID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            result = 31 * result + (this.userID == null ? 0 : this.userID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectorData other = (ConnectorData)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return !(this.userID == null ? other.userID != null : !this.userID.equals(other.userID));
        }

        public String toString() {
            String result = StringUtil.safe((String)this.host);
            if (this.userID != null) {
                result = String.valueOf(this.userID) + TCPUtil.CREDENTIALS_SEPARATOR + result;
            }
            if (this.port != -1) {
                result = String.valueOf(result) + TCPUtil.PORT_SEPARATOR + this.port;
            }
            return result;
        }

        private static URI parse(String description) throws URISyntaxException {
            return new URI("tcp://" + description);
        }
    }
}

