/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;

public class ReferenceableDataSource
extends BasicEmbeddedDataSource40
implements ObjectFactory {
    private static final long serialVersionUID = 1872877359127597176L;
    private static final Class<?>[] STRING_ARG = new Class[]{"".getClass()};
    private static final Class<?>[] INT_ARG = new Class[]{Integer.TYPE};
    private static final Class<?>[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private static final Class<?>[] SHORT_ARG = new Class[]{Short.TYPE};

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context nameContext, Hashtable<?, ?> environment) throws Exception {
        Reference ref;
        String className;
        Object ds = null;
        if (refObj instanceof Reference && (className = (ref = (Reference)refObj).getClassName()) != null && className.startsWith("org.apache.derby.jdbc.Embedded")) {
            ds = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            ReferenceableDataSource.setBeanProperties(ds, ref);
        }
        return ds;
    }

    private static void setBeanProperties(Object ds, Reference ref) throws Exception {
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            Object argValue;
            Method m;
            RefAddr attribute = e.nextElement();
            String propertyName = attribute.getType();
            String value = (String)attribute.getContent();
            String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
            try {
                m = ds.getClass().getMethod(methodName, STRING_ARG);
                argValue = value;
            }
            catch (NoSuchMethodException nsme) {
                try {
                    m = ds.getClass().getMethod(methodName, INT_ARG);
                    argValue = Integer.valueOf(value);
                }
                catch (NoSuchMethodException nsme2) {
                    try {
                        m = ds.getClass().getMethod(methodName, BOOLEAN_ARG);
                        argValue = Boolean.valueOf(value);
                    }
                    catch (NoSuchMethodException nsme3) {
                        m = ds.getClass().getMethod(methodName, SHORT_ARG);
                        argValue = Short.valueOf(value);
                    }
                }
            }
            m.invoke(ds, argValue);
        }
    }
}

