/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class DecryptionManager {
    private static final byte[] modulusBytes__ = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private static final BigInteger modulus__ = new BigInteger(1, modulusBytes__);
    private static final byte[] baseBytes__ = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private static final BigInteger base__ = new BigInteger(1, baseBytes__);
    private static final int exponential_length__ = 255;
    private KeyPairGenerator keyPairGenerator_;
    private KeyPair keyPair_;
    private KeyAgreement keyAgreement_;
    private DHParameterSpec paramSpec_;
    private static final String SHA_1_PRNG_ALGORITHM = "SHA1PRNG";
    private static final int SECMEC_USRSSBPWD_SEED_LEN = 8;
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    DecryptionManager() throws SQLException {
        try {
            if (Security.getProvider("IBMJCE") == null) {
                Class<?> clazz = Class.forName("IBMJCE");
                Security.addProvider((Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            this.paramSpec_ = new DHParameterSpec(modulus__, base__, 255);
            this.keyPairGenerator_ = KeyPairGenerator.getInstance("DH", "IBMJCE");
            this.keyPairGenerator_.initialize(this.paramSpec_);
            this.keyPair_ = this.keyPairGenerator_.generateKeyPair();
            this.keyAgreement_ = KeyAgreement.getInstance("DH", "IBMJCE");
            this.keyAgreement_.init(this.keyPair_.getPrivate());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("java.lang.ClassNotFoundException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (IllegalAccessException e) {
            throw new SQLException("java.lang.IllegalAccessException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (InstantiationException e) {
            throw new SQLException("java.lang.InstantiationException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (NoSuchMethodException e) {
            throw new SQLException("java.lang.NoSuchMethodException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (InvocationTargetException e) {
            throw new SQLException("java.lang.reflect.InvocationTargetException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (NoSuchProviderException e) {
            throw new SQLException("java.security.NoSuchProviderException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("java.security.NoSuchAlgorithmException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SQLException("java.security.InvalidAlgorithmParameterException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
        catch (InvalidKeyException e) {
            throw new SQLException("java.security.InvalidKeyException is caught when initializing EncryptionManager '" + e.getMessage() + "'");
        }
    }

    public byte[] obtainPublicKey() {
        byte[] publicEnc = this.keyPair_.getPublic().getEncoded();
        BigInteger aPub = ((DHPublicKey)this.keyPair_.getPublic()).getY();
        byte[] aPubKey = aPub.toByteArray();
        if (aPubKey.length == 33 && aPubKey[0] == 0) {
            byte[] newKey = new byte[32];
            for (int i = 0; i < newKey.length; ++i) {
                newKey[i] = aPubKey[i + 1];
            }
            return newKey;
        }
        if (aPubKey.length < 32) {
            int i;
            byte[] newKey = new byte[32];
            for (i = 0; i < 32 - aPubKey.length; ++i) {
                newKey[i] = 0;
            }
            for (int j = i; j < newKey.length; ++j) {
                newKey[j] = aPubKey[j - i];
            }
            return newKey;
        }
        return aPubKey;
    }

    private byte[] calculateDecryptionToken(int securityMechanism, byte[] initVector) {
        byte[] token;
        block5: {
            block4: {
                token = new byte[8];
                if (securityMechanism != 7) break block4;
                if (initVector.length < 8) {
                    System.arraycopy(initVector, 0, token, 0, initVector.length);
                    for (int i = initVector.length; i < 8; ++i) {
                        token[i] = 0;
                    }
                } else {
                    System.arraycopy(initVector, 0, token, 0, 8);
                }
                break block5;
            }
            if (securityMechanism != 9) break block5;
            for (int i = 0; i < 8; ++i) {
                token[i] = initVector[i + 12];
            }
        }
        return token;
    }

    public byte[] decryptData(byte[] cipherText, int securityMechanism, byte[] initVector, byte[] sourcePublicKey) throws SQLException {
        byte[] plainText = null;
        byte[] token = this.calculateDecryptionToken(securityMechanism, initVector);
        try {
            int i;
            KeyFactory keyFac = KeyFactory.getInstance("DH", "IBMJCE");
            BigInteger publicKey = new BigInteger(1, sourcePublicKey);
            DHPublicKeySpec dhKeySpec = new DHPublicKeySpec(publicKey, modulus__, base__);
            PublicKey pubKey = keyFac.generatePublic(dhKeySpec);
            this.keyAgreement_.doPhase(pubKey, true);
            byte[] sharedSecret = this.keyAgreement_.generateSecret();
            byte[] newKey = new byte[32];
            if (sharedSecret.length == 33 && sharedSecret[0] == 0) {
                for (i = 0; i < newKey.length; ++i) {
                    newKey[i] = sharedSecret[i + 1];
                }
            }
            if (sharedSecret.length < 32) {
                for (i = 0; i < 32 - sharedSecret.length; ++i) {
                    newKey[i] = 0;
                }
                for (int j = i; j < sharedSecret.length; ++j) {
                    newKey[j] = sharedSecret[j - i];
                }
            }
            byte[] key = new byte[8];
            if (sharedSecret.length == 32) {
                for (i = 0; i < 8; ++i) {
                    key[i] = sharedSecret[i + 12];
                }
            } else if (sharedSecret.length == 33 || sharedSecret.length < 32) {
                for (i = 0; i < 8; ++i) {
                    key[i] = newKey[i + 12];
                }
            } else {
                throw new SQLException("sharedSecret key length error " + sharedSecret.length);
            }
            for (int i2 = 0; i2 < 8; ++i2) {
                byte temp = key[i2];
                int changeParity = 1;
                for (int j = 0; j < 8; ++j) {
                    if (temp < 0) {
                        changeParity = 1 - changeParity;
                    }
                    temp = (byte)(temp << 1);
                }
                if (changeParity != true) continue;
                if ((key[i2] & 1) != 0) {
                    int n = i2;
                    key[n] = (byte)(key[n] & 0xFE);
                    continue;
                }
                int n = i2;
                key[n] = (byte)(key[n] | 1);
            }
            SecretKeySpec desKey = new SecretKeySpec(key, "DES");
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "IBMJCE");
            IvParameterSpec ivParam = new IvParameterSpec(token);
            cipher.init(2, (Key)desKey, ivParam);
            plainText = cipher.doFinal(cipherText);
        }
        catch (NoSuchProviderException e) {
            throw new SQLException("java.security.NoSuchProviderException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("java.security.NoSuchAlgorithmException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (InvalidKeySpecException e) {
            throw new SQLException("java.security.InvalidKeySpecException is caught when encrypting data");
        }
        catch (InvalidKeyException e) {
            throw new SQLException("java.security.InvalidKeyException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (NoSuchPaddingException e) {
            throw new SQLException("javax.crypto.NoSuchPaddingException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (BadPaddingException e) {
            throw new SQLException("javax.crypto.BadPaddingException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SQLException("java.security.InvalidAlgorithmParameterException is caught when encrypting data '" + e.getMessage() + "'");
        }
        catch (IllegalBlockSizeException e) {
            throw new SQLException("javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + e.getMessage() + "'");
        }
        return plainText;
    }

    protected static byte[] generateSeed() throws SQLException {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(SHA_1_PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SQLException("java.security.NoSuchAlgorithmException is caught when initializing DecryptionManager '" + nsae.getMessage() + "'");
        }
        byte[] randomSeedBytes = new byte[8];
        secureRandom.setSeed(secureRandom.generateSeed(8));
        secureRandom.nextBytes(randomSeedBytes);
        return randomSeedBytes;
    }

    protected static String toHexString(byte[] data, int offset, int length) {
        StringBuffer s = new StringBuffer(length * 2);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int high_nibble = (data[i] & 0xF0) >>> 4;
            int low_nibble = data[i] & 0xF;
            s.append(hex_table[high_nibble]);
            s.append(hex_table[low_nibble]);
        }
        return s.toString();
    }

    protected static byte[] toHexByte(String str, int offset, int length) {
        byte[] data = new byte[(length - offset) * 2];
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            char ch = str.charAt(i);
            int high_nibble = (ch & 0xF0) >>> 4;
            int low_nibble = ch & 0xF;
            data[i] = (byte)high_nibble;
            data[i + 1] = (byte)low_nibble;
        }
        return data;
    }
}

